package com.bxm.localnews.activity.rank;

import com.bxm.localnews.activity.dto.CurrentUserRankDTO;
import com.bxm.localnews.activity.dto.RankBriefDTO;
import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankDetailDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.dto.InteractRankInfo;
import com.bxm.localnews.dto.UserInviteOrderVO;
import com.bxm.localnews.vo.ForumRankVo;

import java.util.List;
import java.util.Map;

/**
 * @Author: pf.w
 * @Date: 2020/6/4 9:25
 *
 * （出现了重复动作，应该把逻辑抽象让实现方式更优雅--stay task for myself or NB）
 */

public interface RankSelfService {


    /**
     * 发帖榜 详情信息
     * @param param
     * @return
     */
    RankDetailDTO rankForumList(RankParam param);

    /**
     * 互动榜 详情信息
     * @param param
     * @return
     */
    RankDetailDTO rankInteractList(RankParam param);

    /**
     * 收徒榜 详情信息
     * @param param
     * @return
     */
    RankDetailDTO rankInviteList(RankParam param);


    /**
     * 榜单简略信息
     * @param
     * @return
     */
    RankBriefMocDto buildTopUserInfo(RankParam param);


    /**
     * load forum rank from db and save to redis
     * @param areaCode
     * @return
     */
    List<ForumRankVo> loadForumRankFromDb(String areaCode);

    /**
     * load interact rank from  db  and save to redis
     * @param areaCode
     * @return
     */
    List<InteractRankInfo> loadInteractRankFromDb(String areaCode);

    /**
     * load invite rank from  db and save to redis
     * @param areaCode
     * @return
     */
    List<UserInviteOrderVO> loadInviteRankFromDb(String areaCode);

    /**
     * 个人用户热度详情
     * @param param
     * @return
     */
    CurrentUserRankDTO doCurrentUser(RankParam param);

    /**
     * 个人在榜上的排名
     * @return
     */
    Map<String,Integer> rankForUser(Long userId);
}
