package com.bxm.localnews.activity.rank.impl;

import com.bxm.localnews.activity.common.config.ActivityProperties;
import com.bxm.localnews.activity.common.constant.RankEnum;
import com.bxm.localnews.activity.dto.CurrentUserRankDTO;
import com.bxm.localnews.activity.dto.RankBriefMocDto;
import com.bxm.localnews.activity.dto.RankCompositeDTO;
import com.bxm.localnews.activity.dto.RankDetailDTO;
import com.bxm.localnews.activity.param.RankParam;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.activity.rank.RankService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: pf.w
 * @Date: 2020/6/3 20:47
 */
@Service
@Log4j2
public class RankServiceImpl implements RankService {

    @Autowired
    private RankSelfService rankSelfService;

    @Autowired
    private ActivityProperties activityProperties;

    private static String All = "all";

    @Override
    public RankBriefMocDto rankBriefList(RankParam param) {

        log.debug("input param : {}", param);

        //总开关
        if (!activityProperties.getRankType().get(All)) {
            return null;
        }
        RankBriefMocDto result = rankSelfService.buildTopUserInfo(param);

        if (log.isDebugEnabled()) {
            log.debug("result : {}", result);
        }
        return result;
    }

    @Override
    public RankCompositeDTO rankCompositeInfo(RankParam param) {
        log.debug("param : {}", param);

        //总开关
        if (!activityProperties.getRankType().get(All)) {
            return null;
        }

        RankCompositeDTO rankCompositeDTO = buildRankList(param);

        if (log.isDebugEnabled()) {
            log.debug("rankCompositeDTO :{}", rankCompositeDTO);
        }
        return rankCompositeDTO;
    }

    private CurrentUserRankDTO buildCurrentUserRankInfo(RankParam param) {
        return rankSelfService.doCurrentUser(param);
    }

    private RankCompositeDTO buildRankList(RankParam param) {
        RankCompositeDTO rankCompositeDTO = new RankCompositeDTO();

        //个人上榜信息 key-榜单类型  value-排名
        Map<String, Integer> ranForUser = new HashMap<>();

        //放置有值的榜单
        List<RankDetailDTO> result = new ArrayList<>();
        //放置空榜单  -空榜单要动态放到榜单最后
        List<RankDetailDTO> resultForNull = new ArrayList<>();

        //发帖榜  -先判断该榜单开关
        if (activityProperties.getRankType().get(RankEnum.FORUM.name().toLowerCase())) {
            RankDetailDTO rankDetailDTO = rankSelfService.rankForumList(param);

            if (rankDetailDTO.getRankUsers().size() > 0) {

                //个人在榜单中的排行
                for (int i = 0; i < rankDetailDTO.getRankUsers().size(); i++) {
                    if (rankDetailDTO.getRankUsers().get(i).getForumRankUser().getRankUserId().toString().equals(param.getUserId
                            ().toString())) {
                        ranForUser.put(RankEnum.FORUM.name(), i + 1);
                        break;
                    }
                }
            }

            sortRank(result, resultForNull, rankDetailDTO, RankEnum.FORUM, param, ranForUser);
        }
        //互动榜 -先判断该榜单开关
        if (activityProperties.getRankType().get(RankEnum.INTERACT.name().toLowerCase())) {
            RankDetailDTO rankDetailDTO = rankSelfService.rankInteractList(param);

            if (rankDetailDTO.getRankUsers().size() > 0) {
                //个人在榜单中的排行
                for (int i = 0; i < rankDetailDTO.getRankUsers().size(); i++) {
                    if (rankDetailDTO.getRankUsers().get(i).getInteractRankUser().getRankUserId().toString().equals(param
                            .getUserId().toString())) {
                        ranForUser.put(RankEnum.INTERACT.name(), i + 1);
                        break;
                    }
                }
            }

            sortRank(result, resultForNull, rankDetailDTO, RankEnum.INTERACT, param, ranForUser);
        }
        //邀请榜 -先判断该榜单开关
        if (activityProperties.getRankType().get(RankEnum.INVITE.name().toLowerCase())) {
            RankDetailDTO rankDetailDTO = rankSelfService.rankInviteList(param);

            if (rankDetailDTO.getRankUsers().size() > 0) {
                //个人在榜单中的排行
                for (int i = 0; i < rankDetailDTO.getRankUsers().size(); i++) {
                    if (rankDetailDTO.getRankUsers().get(i).getInviteRankUser().getRankUserId().toString().equals(param
                            .getUserId().toString())) {
                        ranForUser.put(RankEnum.INVITE.name(), i + 1);
                        break;
                    }
                }
            }

            sortRank(result, resultForNull, rankDetailDTO, RankEnum.INVITE, param, ranForUser);
        }
        //空榜单放后边
        result.addAll(resultForNull);

        CurrentUserRankDTO currentUserRankDTO = this.buildCurrentUserRankInfo(param);
        currentUserRankDTO.setRankForUser(ranForUser);

        rankCompositeDTO.setRankList(result);
        rankCompositeDTO.setCurrentUser(currentUserRankDTO);
        return rankCompositeDTO;
    }


    /**
     * 将空榜单放到列表末尾
     *
     * @param result
     * @param resultForNull 无数据的排行榜
     * @param rankDetailDTO
     * @param rankEnum
     * @param param
     * @param ranForUser
     */
    private void sortRank(List<RankDetailDTO> result,
                          List<RankDetailDTO> resultForNull,
                          RankDetailDTO rankDetailDTO,
                          RankEnum rankEnum, RankParam param,
                          Map<String, Integer> ranForUser) {
        if (StringUtils.isNotBlank(param.getActiveRankCode())
                && param.getActiveRankCode().equals(rankEnum.name())) {
            rankDetailDTO.setActive(Boolean.TRUE);
        }

        //默认展开发帖榜
        if (StringUtils.isBlank(param.getActiveRankCode())
                && rankDetailDTO.getRankCode().equals(RankEnum.FORUM.name())) {
            rankDetailDTO.setActive(Boolean.TRUE);
        }

        if (rankDetailDTO.getRankUsers().size() > 0) {
            result.add(rankDetailDTO);
        } else {
            resultForNull.add(rankDetailDTO);
        }
    }

}
