package com.bxm.localnews.activity.record.grade.impl;

import com.bxm.localnews.activity.vo.RecordGradeContext;
import org.springframework.stereotype.Component;

/**
 * 拼音评分策略
 * 根据原始口令转换的拼音与识别结果进行拼音比较，计算两者的字符串编辑距离
 * @author liujia
 */
@Component
public class PinyinStrategy extends AbstractGradStrategy {

    @Override
    public void grade(RecordGradeContext context) {
        String target = context.getPinyinTarget();
        int distance = minDistance(target, context.getPinyinResult());
        int length = target.length();
        float score = 0F;

        //如果编辑距离小于总长度
        if (distance < length) {
            score = (float) (length - distance) / length * 100;
        }

        context.getGrade().setPinyinScore(score);
    }

}
