package com.bxm.localnews.activity.service;

import com.bxm.localnews.activity.param.HelpInfoQueryParam;
import com.bxm.localnews.activity.vo.*;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

public interface HelpInfoService {

    /**
     * 判断是否活动区域
     *
     * @param areaCode
     * @return
     */
    Boolean isActiveArea(String areaCode);

    /**
     * 获取助力首页信息
     *
     * @param size
     * @param userId
     * @param pageType
     * @return
     */
    HelpIndexPageInfo getIndexPageInfo(Integer size, Long userId, Integer pageType);

    /**
     * 获取排行榜
     *
     * @param param
     * @return
     */
    PageWarper<HelpRankInfo> getRankingList(HelpInfoQueryParam param);

    /**
     * 获取用户排名信息
     *
     * @param userId
     * @return
     */
    HelpRankInfo getUserRank(Long userId);

    /**
     * 助力
     *
     * @param areaCode
     * @param areaName
     * @param userId
     * @param type
     * @param teamName
     * @param inviteUserId
     * @return
     */
    Message help(String areaCode, String areaName, Long userId, Byte type, String teamName, Long inviteUserId);

    /**
     * 团队头像编辑
     *
     * @param userId
     * @param teamImg
     * @return
     */
    Message updateTeamImg(Long userId, String teamImg);

    /**
     * 获取用户证书信息
     *
     * @param userId
     * @return
     */
    HelpCertInfo getUserCert(Long userId);

    /**
     * 分享生成帖子
     *
     * @param userId
     * @param areaCode
     * @param base64Str
     * @return
     */
    Message shareCreatePost(Long userId, String areaCode, String base64Str);

    /**
     * 根据用户id获取助力信息
     *
     * @param userId
     * @return
     */
    HelpBaseInfo getUserHelpBaseInfo(Long userId);

    /**
     * 获取首页弹窗信息
     *
     * @param areaCode
     * @param userId
     * @return
     */
    HelpWindowInfo getHelpWindowInfo(String areaCode, Long userId);

    /**
     * 创建助力用户邀请关系
     *
     * @param userId
     * @param inviteUserId
     * @return
     */
    Message createHelpUserInvite(Long userId, Long inviteUserId);
}
