package com.bxm.localnews.activity.service.impl;

import com.bxm.localnews.activity.domain.ActivityMapper;
import com.bxm.localnews.activity.service.ActivityService;
import com.bxm.localnews.activity.vo.Activity;
import com.bxm.localnews.activity.vo.ActivityDTO;
import com.bxm.localnews.common.vo.RdPage;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ActivityServiceImpl implements ActivityService {

    private ActivityMapper activityMapper;

    @Autowired
    public ActivityServiceImpl(ActivityMapper activityMapper) {
        this.activityMapper = activityMapper;
    }

    @Override
    public Page<Activity> selectPageList(Integer current, Integer pageSize) {
        PageHelper.startPage(
                current == null ? RdPage.PAGE_NUM_DEFAULT : current,
                pageSize == null ? RdPage.PAGE_SIZE_DEFAULT : pageSize);
        List<Activity> list = this.activityMapper.selectPageList();
        return (Page) list;
    }
}
