package com.bxm.localnews.activity.service.redpacket.command;

import com.bxm.localnews.activity.common.constant.ObtainStatesEnum;
import com.bxm.localnews.activity.common.constant.RedPacketObtainStatesEnum;
import com.bxm.localnews.activity.dto.UserObtainRpStatesDTO;
import com.bxm.localnews.activity.vo.RedPacket;

import java.math.BigDecimal;

/**
 * @ClassName RedPackeStatusService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/4/30 15:41
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/4/30 15:41
 **/
public interface RedPacketStateService {
    /**
     * 红包状态校验
     * @param redPacket 红包实体
     * @param userId 用户id
     * @return
     */
    RedPacketObtainStatesEnum rpStatesCheck(RedPacket redPacket, Long userId);

    /**
     * 该红包是否被用户领取过
     * @param rpId
     * @param userId
     * @return
     */
    Boolean isObtainedByUser(Long rpId,Long userId);


    /**
     * 获取红包的领取状态
     * @param amount 红包总金额
     * @param surplusAmount 红包剩余金额
     * @return
     */
    ObtainStatesEnum rpObtainStatus(BigDecimal amount, BigDecimal surplusAmount);


    /**
     * 获取用户与该红包的领取关系
     * @param surplusAmount 红包剩余金额
     * @param userId 用户id
     * @param rpId 红包id
     * @return
     */
    UserObtainRpStatesDTO userObtainRpStates(BigDecimal surplusAmount, Long userId, Long rpId);
}
