package com.bxm.localnews.activity.service.redpacket.command.impl;

import com.bxm.localnews.activity.common.constant.CashEnum;
import com.bxm.localnews.activity.common.constant.RedPacketAmountStatesEnum;
import com.bxm.localnews.activity.domain.RedPacketMapper;
import com.bxm.localnews.activity.domain.RedPacketObtainHistoryMapper;
import com.bxm.localnews.activity.dto.RedPacketObtainDOT;
import com.bxm.localnews.activity.dto.ScoreDto;
import com.bxm.localnews.activity.dto.SubtractDTO;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketAmountService;
import com.bxm.localnews.activity.service.redpacket.command.RedPacketPushService;
import com.bxm.localnews.activity.common.utils.AmountUtil;
import com.bxm.localnews.activity.vo.RedPacket;
import com.bxm.localnews.activity.vo.RedPacketObtainHistory;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.param.AccountCashParam;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.uuid.SequenceCreater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * @ClassName RedPacketAmountServiceImpl
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2019/5/9 19:31
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2019/5/9 19:31
 **/
@Service
public class RedPacketAmountServiceImpl implements RedPacketAmountService{

    private final static Logger logger = LoggerFactory.getLogger(RedPacketAmountServiceImpl.class);
    @Autowired
    private RedPacketMapper redPacketMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private RedPacketObtainHistoryMapper obtainHistoryMapper;
    @Autowired
    private UserAccountIntegrationService userAccountIntegrationService;
    @Autowired
    private BizLogService bizLogService;
    @Autowired
    private RedPacketPushService redPacketPushService;

    @Override
    @Transactional
    public SubtractDTO setSurplusAmount(RedPacket redPacket,ScoreDto scoreDto,User user,Integer platform) {
        // 计算奖励金额
        BigDecimal rewardAmount = AmountUtil.calculateRewardAmount(redPacket.getAmount(), redPacket.getExpectNum(), scoreDto.getScore());

        // 减扣红包剩余金额
        RedPacketObtainDOT redPacketObtainDto = convertToRedPacketObtainDOT(redPacket, rewardAmount);
        Integer result = redPacketMapper.subtractSurplusAmount(redPacketObtainDto);
        if (result == 0){
            return new SubtractDTO(Boolean.FALSE);
        }

        // 增加红包获取记录
        RedPacketObtainHistory redPacketObtainHistory = convertToRedPacketObtainHistory(redPacket, scoreDto, user, redPacketObtainDto.getActualAmount());
        result = obtainHistoryMapper.addOne(redPacketObtainHistory);
        if (result == 0){
            throw new BusinessException("增加红包获取记录失败");
        }

        // 增加可提现金额（数值为实际领取金额）
        Boolean addMoneyResult = addCash(user.getId(), redPacketObtainDto.getActualAmount());
        if (!addMoneyResult){
            throw new BusinessException("增加可提现金额失败");
        }
        bizLogService.receiveRedPacket(user.getId(),redPacketObtainDto.getActualAmount(),platform);

        // 红包余额为0 向红包所有者推送红包被领完
        if (redPacketObtainDto.getSurplusAmount().compareTo(BigDecimal.ZERO) == 0) {
            logger.info("红包余额为0,推送给用户[{}],红包[{}]被领完",redPacket.getUserId(),redPacket.getId());
            redPacketPushService.pushRunOutMoney(redPacket.getUserId(),redPacket.getId());
        }
        return new SubtractDTO(Boolean.TRUE,redPacketObtainDto.getActualAmount());
    }

    /**
     * 为用户添加可提现金额
     */
    private Boolean addCash(Long userId, BigDecimal scoreMoney) {
        AccountCashParam param = new AccountCashParam();
        param.setUserId(userId);
        param.setAddTotal(true);
        param.setCashType(CashEnum.DRAWABLEL_CASH.name());// 可提现
        param.setCash(scoreMoney);
        param.setCashFlowType("COMMAND_RED_PACKET");
        return userAccountIntegrationService.addCash(param);
    }

    private RedPacketObtainHistory convertToRedPacketObtainHistory(RedPacket redPacket, ScoreDto scoreDto,User user, BigDecimal actualAmount) {
        RedPacketObtainHistory redPacketObtainHistory = new RedPacketObtainHistory();
        redPacketObtainHistory.setId(sequenceCreater.nextLongId());
        redPacketObtainHistory.setOwnerUserName(redPacket.getUserName());
        redPacketObtainHistory.setRpId(redPacket.getId());
        redPacketObtainHistory.setUserId(user.getId());
        redPacketObtainHistory.setUserName(user.getNickname());
        redPacketObtainHistory.setUserImg(user.getHeadImg());
        redPacketObtainHistory.setRecordUrl(scoreDto.getCommandUrl());
        redPacketObtainHistory.setRecordLength(scoreDto.getLength());
        redPacketObtainHistory.setObtainAmount(actualAmount);
        redPacketObtainHistory.setScore(scoreDto.getScore());
        return redPacketObtainHistory;
    }

    private RedPacketObtainDOT convertToRedPacketObtainDOT(RedPacket redPacket,BigDecimal scoreMoney){
        RedPacketObtainDOT redPacketObtainDto = new RedPacketObtainDOT();
        redPacketObtainDto.setId(redPacket.getId());
        redPacketObtainDto.setOldVersion(redPacket.getVersion());
        redPacketObtainDto.setActualNum(redPacket.getActualNum() + 1);
        redPacketObtainDto.setObtainStatus(redPacket.getObtainStatus());

        BigDecimal oldSurplusAmount = redPacket.getSurplusAmount();
        if (oldSurplusAmount.compareTo(scoreMoney) > 0) {// 红包余额>减扣金额
            redPacketObtainDto.setSurplusAmount(oldSurplusAmount.subtract(scoreMoney));
        } else {
            // 红包余额<=用户评分金额 ：红包余额 = 0  ，设置红包状态已领完,
            scoreMoney = redPacket.getSurplusAmount();
            redPacketObtainDto.setSurplusAmount(new BigDecimal(0));
            redPacketObtainDto.setObtainStatus(RedPacketAmountStatesEnum.UNOBTAINABLE.getType());
        }
        redPacketObtainDto.setActualAmount(scoreMoney);
        redPacketObtainDto.setNewVersion(redPacket.getVersion()+1);
        return redPacketObtainDto;
    }
}
