package com.bxm.localnews.activity.strategy.dailyConcreteStrategy;

import com.bxm.localnews.activity.domain.BrowseRecordMapper;
import com.bxm.localnews.activity.dto.NewsMissionRewardDto;
import com.bxm.localnews.activity.param.TaskContext;
import com.bxm.localnews.activity.vo.BrowseRecord;
import com.bxm.localnews.activity.vo.DailyTask;
import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.common.constant.TaskEnum;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.vo.User;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

@Service
public class NewsBrowseTaskStrategy extends AbstractDailyTaskStrategy {

    public NewsBrowseTaskStrategy(RedisStringAdapter redisStringAdapter,
                                  RedisHashMapAdapter redisHashMapAdapter,
                                  NewsProperties newsProperties,
                                  UserIntegrationService userIntegrationService,
                                  BrowseRecordMapper browseRecordMapper) {
        super(redisStringAdapter, redisHashMapAdapter, newsProperties, userIntegrationService, browseRecordMapper);
    }

    @Override
    public boolean support(TaskEnum taskEnum) {
        return taskEnum.equals(TaskEnum.TASK_FIRST_BROWSE);
    }

    @Override
    protected Message customJudge(TaskContext taskContext) {
        //转发文章被别人阅读触发任务前置判断
        if (taskContext.getUserId().equals(Long.valueOf(taskContext.getRelationId()))) {
            return Message.build(false, "自己阅读自己分享的文章不做奖励处理!");
        }

        //判断浏览人是否有效
        User user = userIntegrationService.selectByPrimaryKey(Long.valueOf(taskContext.getRelationId()));
        if (user == null) {
            return Message.build(false, "浏览人[{" + taskContext.getRelationId() + "}]不存在!");
        }
        taskContext.addParam("user", user);
        return Message.build(true);
    }

    @Override
    protected NewsMissionRewardDto processing(TaskContext taskContext) {
        String relationId = taskContext.getRelationId();
        Long userId = taskContext.getUserId();

        //得到用户
        User user = (User) taskContext.getParamMap().get("user");

        //得到用户类型
        String browseUserType = getBrowseUserType(user.getWeixin());

        //用户奖励X朵小红花
        int reward = getReward(user.getWeixin());
        DailyTask dailyTask = taskContext.getDailyTask();
        dailyTask.setReward(BigDecimal.valueOf(reward));

        byte isAward = 0;

        //判断用户今日有无浏览任何用户分享的内容
        Date browseTime = DateUtils.parse(DateUtils.formatAtWill(new Date(), DateUtils.DATE_FORMAT));
        BrowseRecord browseRecord = browseRecordMapper.selectBrowseRecord(Long.valueOf(relationId), browseTime, (byte) 1);
        Long recordId = nextId();
        if (browseRecord == null) {
            logger.info("浏览人[{}]今天还未浏览任何用户的分享内容----给分享人[{}]添加金币[{}],建立关系的id：[{}]", relationId, userId, reward, recordId);
            taskContext.setAddGold(true);
            isAward = 1;
        }

        //无论是不是第一次打开看到文章，都要进行记录
        BrowseRecord br = new BrowseRecord(recordId, userId, Long.valueOf(relationId), null,
                browseTime, browseUserType, isAward, reward);
        browseRecordMapper.insert(br);

        if (isAward == 0) {
            return convertTask(taskContext.getTaskEnum(), 0L, userId);
        }

        return convertTask(taskContext.getTaskEnum(), (long) reward, userId);
    }

    /**
     * 获得用户类型
     * @param weixin
     * @return
     */
    private String getBrowseUserType(String weixin) {
        String browseUserType = "OLD_USER";
        if (StringUtils.isEmpty(weixin)) {
            browseUserType = "NEW_USER";
        }
        return browseUserType;
    }

    /**
     * 获得小红花奖励数
     * @param weixin
     * @return
     */
    private int getReward(String weixin) {
        int reward;
        //relationId是否是新用户
        if (StringUtils.isEmpty(weixin)) {
            //生成20到50朵小火花
            reward = RandomUtils.nextInt(20, 50);
        } else {
            reward = 3;
        }
        return reward;
    }

    @Override
    protected boolean isSupportPushMessage() {
        return false;
    }

}
