package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.common.config.HelpInfoProperties;
import com.bxm.localnews.activity.config.BaConfig;
import com.bxm.localnews.activity.domain.HelpInfoMapper;
import com.bxm.localnews.activity.vo.HelpUserInfo;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

import static org.apache.commons.lang3.StringUtils.join;

@Component
@Slf4j
public class HelpRemindTask extends AbstractTaskCallback<String> {

    @Resource
    private HelpInfoMapper helpInfoMapper;

    @Resource
    private ScheduleService scheduleService;

    @Resource
    private PushMsgIntegrationService pushMsgIntegrationService;

    @Resource
    private HelpInfoProperties helpInfoProperties;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private BaConfig baConfig;

    @Resource
    private BaseUrlFacadeService baseUrlFacadeService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("蓝天救援队定时提醒任务参数：{}", param);
        if (StringUtils.isBlank(param)) {
            return ReturnT.FAIL;
        }

        //获取推送用户
        List<Long> userIdList = helpInfoMapper.getHelpUserIdList();

        Date endTime = DateUtils.parse(param);
        if (new Date().after(endTime)) {
            this.pushMsgIntegrationService.pushHelpActivityEndMsg(helpInfoProperties.getPostDetail(), userIdList);

            scheduleService.remove(this.beanName());
            return ReturnT.SUCCESS;
        }

        if (redisStringAdapter.hasKey(RedisConfig.BLUE_SKY_HELP_COMPLETE.copy())) {
            return ReturnT.SUCCESS;
        }

        //活动前三天提醒
        if (CollectionUtils.isNotEmpty(userIdList)) {
            Integer dayNum = DateUtils.getDiffDays(new Date(), endTime, true) + 1;
            for (Long userId : userIdList) {
                HelpUserInfo helpUserInfo = helpInfoMapper.getHelpUserInfo(userId);
                String url = join(baseUrlFacadeService.getContentViewSceneBaseUrl(), baConfig.getBlueSkySharePage(),
                        "?userId=", userId, "&areaCode=", helpUserInfo.getLocationCode(), "&areaName=", helpUserInfo.getLocationName());

                this.pushMsgIntegrationService.pushHelpActivityNearlyEndMsg(dayNum, url, userId);
            }
        }

        return ReturnT.SUCCESS;
    }

}
