package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.service.SignFacadeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncNotificationTask extends AbstractCronTask<String> {

    @Resource
    private SignFacadeService signFacadeService;

    @Override
    protected ReturnT<String> service(String param) {
        signFacadeService.noticeUserSign();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncNotificationTask";
    }

    @Override
    public String cron() {
        return "0 0 19 * * ?";
    }

    @Override
    public String description() {
        return "向昨日签到今日未签到的人发送消息推送";
    }

}
