package com.bxm.localnews.activity.task;

import com.bxm.localnews.activity.common.constant.RankEnum;
import com.bxm.localnews.activity.rank.RankSelfService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 定时更新榜单数据   每两小时更新一次
 *
 * @Author: pf.w
 * @Date: 2020/6/5 14:02
 */
@Component
@Slf4j
public class SyncRankTask extends AbstractCronTask<String> {

    @Autowired
    private RankSelfService rankSelfService;

    @Autowired
    RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected ReturnT<String> service(String s) {
        //更新发帖榜
        KeyGenerator forumKey = RedisConfig.RANK_LIST.copy().appendKey(RankEnum.FORUM.name().toLowerCase());
        redisHashMapAdapter.keys(forumKey).forEach(areaCode -> rankSelfService.loadForumRankFromDb(areaCode));
        //更新互动榜
        KeyGenerator interactKey = RedisConfig.RANK_LIST.copy().appendKey(RankEnum.INTERACT.name().toLowerCase());
        redisHashMapAdapter.keys(interactKey).forEach(areaCode -> rankSelfService.loadInteractRankFromDb(areaCode));
        //更新收徒榜
        KeyGenerator inviteKey = RedisConfig.RANK_LIST.copy().appendKey(RankEnum.INVITE.name().toLowerCase());
        redisHashMapAdapter.keys(inviteKey).forEach(areaCode -> rankSelfService.loadInviteRankFromDb(areaCode));

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncRankTask";
    }

    @Override
    public String cron() {
        return "0 0/30 * * * ? ";
    }

    @Override
    public String description() {
        return "同步榜单数据";
    }
}
