package com.bxm.localnews.activity.vote.strategy;

import com.bxm.localnews.activity.dto.VoteDetailDTO;
import com.bxm.localnews.activity.param.VoteParam;
import com.bxm.localnews.activity.param.VotePinParam;
import com.bxm.newidea.component.vo.Message;

/**
 * 投票策略接口
 * @author liujia
 */
public interface IVoteStrategy {
    /**
     * 增加投票次数
     * @param detail 投票插件详情
     * @param param  增加投票需要的相关参数
     * @return 增加结果
     */
    Message addTime(VoteDetailDTO detail, VotePinParam param);

    /**
     * 进行具体的投票动作
     * @param detail 投票插件详情
     * @param param  投票相关参数
     * @return 投票结果
     */
    Message vote(VoteDetailDTO detail, VoteParam param);

    /**
     * 不同策略对状态进行处理，显示不同的文案
     * @param detail 投票插件详情
     * @param param  投票相关参数
     */
    void deal(VoteDetailDTO detail, VotePinParam param);

    /**
     * 策略名称
     * @return
     */
    String name();
}
