/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.ActivityParam;
import com.bxm.localnews.admin.service.AdminActivityService;
import com.bxm.localnews.admin.vo.Activity;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-01 [\u7ba1\u7406]\u6d3b\u52a8\u7ba1\u7406"}, description="\u6d3b\u52a8\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/activity"})
public class AdminActivityController {
    @Resource
    private AdminActivityService adminActivityService;

    @ApiOperation(value="1-1-1 \u83b7\u53d6\u6d3b\u52a8\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u6d3b\u52a8\u6570\u636e")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"admin:activity"})
    public Json<PageWarper<Activity>> getActivityList(ActivityParam activityParam) {
        return ResultUtil.genSuccessResult((Object)this.adminActivityService.queryActivitys(activityParam));
    }

    @ApiOperation(value="1-1-2 \u6d3b\u52a8\u6279\u91cf\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="state", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/batchUpdateActivity"})
    @RequiresPermissions(value={"admin:activity"})
    public Json updateActivityStatusByIds(String ids, Byte state) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String[] id = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminActivityService.updateActivityStateByIds(id, state);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u9009\u62e9\u65b0\u95fb");
    }

    @ApiOperation(value="1-1-3 \u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5", notes="")
    @ApiImplicitParam(name="id", value="\u6d3b\u52a8id", required=true)
    @GetMapping(value={"/getActivityDetail"})
    @RequiresPermissions(value={"admin:activity"})
    public Json<Activity> getActivityDetail(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminActivityService.selectByPrimaryKey(id));
    }

    @ApiOperation(value="1-1-4 \u6d3b\u52a8\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="state", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/updateActivity"})
    @RequiresPermissions(value={"admin:activity"})
    public Json updateActivityStatusById(Long id, Byte state) {
        Activity activity = new Activity();
        activity.setId(id);
        activity.setState(state);
        int flag = this.adminActivityService.updateByPrimaryKeySelective(activity);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-1-5 \u65b0\u589e\u6216\u7f16\u8f91\u6d3b\u52a8", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="startTime", value="\u5f00\u59cb\u65f6\u95f4"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65f6\u95f4"), @ApiImplicitParam(name="name", value="\u540d\u79f0"), @ApiImplicitParam(name="activityPic", value="\u56fe\u7247"), @ApiImplicitParam(name="activityUrl", value="\u5730\u5740"), @ApiImplicitParam(name="id", value="id"), @ApiImplicitParam(name="state", value="\u72b6\u6001"), @ApiImplicitParam(name="remark", value="\u5907\u6ce8")})
    @PostMapping(value={"/saveOrUpdateActivity"})
    @RequiresPermissions(value={"admin:activity"})
    public Json addAdvertDetail(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="name", required=false) String name, @RequestParam(value="activityPic", required=false) String activityPic, @RequestParam(value="activityUrl", required=false) String activityUrl, @RequestParam(value="id", required=false) String id, @RequestParam(value="state", required=false) String state, @RequestParam(value="remark", required=false) String remark) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int flag = 0;
        Activity activity = new Activity(name, activityPic, activityUrl, sdf.parse(startTime), sdf.parse(endTime), Byte.valueOf(state), remark);
        if (StringUtils.isEmpty((CharSequence)id)) {
            flag = this.adminActivityService.insertSelective(activity);
        } else {
            activity.setId(Long.valueOf(Long.parseLong(id)));
            flag = this.adminActivityService.updateByPrimaryKeySelective(activity);
        }
        if (flag <= 0) {
            return ResultUtil.genFailedResult((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        return ResultUtil.genSuccessMsg((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

