/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.AdvertParam;
import com.bxm.localnews.admin.service.AdminAdvertService;
import com.bxm.localnews.admin.vo.Advert;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-02 [\u7ba1\u7406]\u5e7f\u544a\u7ba1\u7406"}, description="\u5e7f\u544a\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/advert"})
public class AdminAdvertController {
    private AdminAdvertService adminAdvertService;

    @Autowired
    public AdminAdvertController(AdminAdvertService adminAdvertService) {
        this.adminAdvertService = adminAdvertService;
    }

    @ApiOperation(value="1-02-1 \u83b7\u53d6\u5e7f\u544a\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u5e7f\u544a\u6570\u636e")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"admin:advert"})
    public Json<PageWarper<Advert>> getAdvertList(AdvertParam advertParam) {
        return ResultUtil.genSuccessResult((Object)this.adminAdvertService.getAdvertList(advertParam));
    }

    @ApiOperation(value="1-02-2 \u83b7\u53d6\u5e7f\u544a\u8be6\u60c5", notes="")
    @GetMapping(value={"/detail"})
    @ApiImplicitParam(name="id", value="id", required=true)
    @RequiresPermissions(value={"admin:advert"})
    public Json<Advert> getAdvertById(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminAdvertService.getAdvertById(id));
    }

    @ApiOperation(value="1-02-3 \u5e7f\u544a\u6279\u91cf\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"batchUpdateStatus"})
    @RequiresPermissions(value={"admin:advert"})
    public Json updateAdvertStatusByIds(String ids, Byte status) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return ResultUtil.genFailedResult((String)"\u5e7f\u544aid\u4e0d\u5b58\u5728");
        }
        String[] id = ids.split(",");
        if (this.adminAdvertService.updateAdvertStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-02-4 \u5e7f\u544a\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"updateStatus"})
    @RequiresPermissions(value={"admin:advert"})
    public Json updateAdvertStatusById(Long id, Byte status) {
        if (this.adminAdvertService.updateAdvertStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-02-5 \u65b0\u589e\u6216\u7f16\u8f91\u5e7f\u544a", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCodes", value="\u5730\u533a\u7f16\u7801\u5b57\u7b26\u4e32,\u4ee5\u201c,\u201d\u5206\u9694")})
    @PostMapping(value={"saveOrUpdateAdvert"})
    @RequiresPermissions(value={"admin:advert"})
    public Json addAdvertDetail(Advert advert, @RequestParam(required=false) String areaCodes) {
        if (this.adminAdvertService.addAdvertDetail(advert, areaCodes) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-02-6 \u5220\u9664\u5e7f\u544a", notes="")
    @PostMapping(value={"deleteAdvert"})
    @ApiImplicitParam(name="id", value="id", required=true)
    @RequiresPermissions(value={"admin:advert"})
    public Json deleteAdvert(Long id) {
        if (this.adminAdvertService.deleteAdvert(id) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u5220\u9664\u5931\u8d25");
    }
}

