/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.dto.ChannelDTO;
import com.bxm.localnews.admin.dto.ChannelStatisDTO;
import com.bxm.localnews.admin.param.ChannelParam;
import com.bxm.localnews.admin.service.AdminChannelService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-04 [\u7ba1\u7406]\u6e20\u9053\u4fe1\u606f\u7ba1\u7406"}, description="\u6e20\u9053\u4fe1\u606f\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/channel"})
public class AdminChannelController {
    @Resource
    private AdminChannelService adminChannelService;

    @ApiOperation(value="1-4-1 \u6e20\u9053\u5217\u8868", notes="")
    @GetMapping(value={"channelList"})
    @RequiresPermissions(value={"admin:channel"})
    public Json<PageWarper<ChannelDTO>> channelList(ChannelParam channelParam) {
        return ResultUtil.genSuccessResult((Object)this.adminChannelService.queryChannelDTOs(channelParam));
    }

    @ApiOperation(value="1-4-2 \u65b0\u589e\u548c\u7f16\u8f91\u529f\u80fd\u529f\u80fd", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="code", value="code", required=true), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=true), @ApiImplicitParam(name="phone", value="\u624b\u673a", required=true), @ApiImplicitParam(name="linker", value="linker", required=true)})
    @PostMapping(value={"saveOrUpdate"})
    @ResponseBody
    @RequiresPermissions(value={"admin:channel"})
    public Json saveOrUpdate(@RequestParam(value="id", required=false) Long id, @RequestParam(value="code") String code, @RequestParam(value="name") String name, @RequestParam(value="phone") String phone, @RequestParam(value="linker") String linker) {
        Channel channel = new Channel(code, name, linker, phone, new Date());
        if (id == null) {
            int count = this.adminChannelService.countByCode(code);
            if (count > 0) {
                return ResultUtil.genFailedResult((String)"\u6e20\u9053\u7f16\u7801\u5df2\u5b58\u5728");
            }
            return this.adminChannelService.insertSelective(channel);
        }
        Channel c = this.adminChannelService.selectById(id);
        if (!code.equals(c.getCode()) && this.adminChannelService.countByCode(code) > 0) {
            return ResultUtil.genFailedResult((String)"\u6e20\u9053\u7f16\u7801\u5df2\u5b58\u5728");
        }
        channel.setId(id);
        return this.adminChannelService.updateBySelective(channel);
    }

    @ApiOperation(value="1-4-3 \u542f\u7528\u548c\u7981\u7528\u529f\u80fd")
    @ApiImplicitParams(value={@ApiImplicitParam(name="channelId", value="id"), @ApiImplicitParam(name="state", value="\u72b6\u6001")})
    @PostMapping(value={"changState"})
    @ResponseBody
    @RequiresPermissions(value={"admin:channel"})
    public Json changState(@RequestParam(value="channelId") Long channelId, @RequestParam(value="state") String state) {
        return this.adminChannelService.changeState(channelId, state);
    }

    @ApiOperation(value="1-04-4 \u6e20\u9053\u4fe1\u606f\u7edf\u8ba1", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="current", value="\u9875\u7801", required=true), @ApiImplicitParam(name="pageSize", value="\u6570\u76ee", required=true)})
    @GetMapping(value={"channelStatis"})
    @ResponseBody
    @RequiresPermissions(value={"admin:channel:channelStatis"})
    public Json<PageWarper<ChannelStatisDTO>> channelStatis(ChannelParam param) {
        return ResultUtil.genSuccessResult((Object)this.adminChannelService.channelStatis(param));
    }
}

