/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.service.AdminMenuService;
import com.bxm.localnews.admin.service.AdminRoleMenuService;
import com.bxm.localnews.admin.vo.AdminMenu;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"1-05 [\u7ba1\u7406]\u83dc\u5355\u7ba1\u7406"}, description="\u83dc\u5355\u680f\u76f8\u5173\u64cd\u4f5c")
@Controller
@RequestMapping(value={"api/admin/menu"})
public class AdminMenuController {
    @Resource
    private AdminMenuService adminMenuService;
    @Resource
    private AdminRoleMenuService adminRoleMenuService;

    @ApiOperation(value="1-5-1 \u6839\u636e\u83b7\u53d6\u7528\u6237\u89d2\u8272\u62e5\u6709\u7684\u83dc\u5355")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
    @GetMapping(value={"getRoleMenu"})
    @ResponseBody
    public Json<List<AdminMenuDTO>> getRoleMenu(Integer roleId) {
        if (roleId == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        return ResultUtil.genSuccessResult((Object)this.adminMenuService.getMenusByRoleId(roleId));
    }

    @RequiresPermissions(value={"admin:menu"})
    @ApiOperation(value="1-5-2 \u6839\u636e\u89d2\u8272\u83b7\u53d6\u83dc\u5355\u5217\u8868")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
    @GetMapping(value={"getUserMenu"})
    @ResponseBody
    public Json<List<AdminMenuDTO>> getMenuByUserId(Long roleId) {
        List allMenus = this.adminMenuService.getMenusByRole(roleId);
        return ResultUtil.genSuccessResult((Object)allMenus);
    }

    @RequiresPermissions(value={"admin:menu"})
    @ApiOperation(value="1-5-3 \u83b7\u53d6\u6240\u6709\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"getAllMenu"})
    @ResponseBody
    public Json<List<AdminMenuDTO>> getAllMenu() {
        List allMenus = this.adminMenuService.getAllMenu();
        return ResultUtil.genSuccessResult((Object)allMenus);
    }

    @ApiOperation(value="1-5-4 \u83b7\u53d6\u6240\u6709\u83dc\u5355\u5217\u8868")
    @ApiImplicitParam(name="menuId", value="\u83dc\u5355id")
    @ResponseBody
    @GetMapping(value={"getMenuInfo"})
    public Json<AdminMenu> getMenuInfo(@RequestParam(value="menuId") Integer menuId) {
        AdminMenu menu = this.adminMenuService.selectByPrimaryKey(menuId);
        return ResultUtil.genSuccessResult((Object)menu);
    }

    @ApiOperation(value="1-5-5 \u83b7\u53d6\u7236\u8282\u70b9\u83dc\u5355")
    @GetMapping(value={"getParentMenuList"})
    @ResponseBody
    public Json<List<AdminMenu>> getParentMenuList() {
        return ResultUtil.genSuccessResult((Object)this.adminMenuService.getParentMenus());
    }

    @RequiresPermissions(value={"admin:menu"})
    @ApiOperation(value="1-5-6 \u4fdd\u5b58\u83dc\u5355")
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public Json saveMenu(@RequestBody AdminMenu adminMenu) {
        if (StringUtils.isEmpty((CharSequence)adminMenu.getName()) || adminMenu.getLevel() == 1 && StringUtils.isEmpty((CharSequence)adminMenu.getPath())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83dc\u5355\u540d\u79f0\u4e3a\u7a7a\u6216\u5b50\u83dc\u5355\u8def\u5f84\u4e3a\u7a7a");
        }
        int flag = this.adminMenuService.upsert(adminMenu);
        if (flag == 1 || flag > 1) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u6570\u636e\u5e93\u5f02\u5e38");
    }

    @RequiresPermissions(value={"admin:menu"})
    @ApiOperation(value="1-5-7 \u5220\u9664\u83dc\u5355")
    @ApiImplicitParam(name="menuId", value="\u83dc\u5355id", required=true)
    @PostMapping(value={"delete"})
    @ResponseBody
    public Json delete(Integer menuId) {
        Integer userNum = this.adminRoleMenuService.countByMenuId(menuId);
        if (userNum > 0) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8be5\u83dc\u5355\u5173\u8054\u5176\u4ed6\u89d2\u8272\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.adminMenuService.deleteByPrimaryKey(menuId);
        return ResultUtil.genSuccessMsg();
    }
}

