/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.service.AdminNewsService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-07 [\u7ba1\u7406]\u65b0\u95fb\u7ba1\u7406"}, description="\u65b0\u95fb\u4e0a\u7ebf\u7ba1\u7406\uff0c\u9632\u6b62\u53d7\u7ba1\u5236\u7684\u5185\u5bb9\u51fa\u73b0\u5728\u7ebf\u4e0a")
@RestController
@RequestMapping(value={"api/admin/news"})
public class AdminNewsController {
    @Resource
    private AdminNewsService adminNewsService;

    @ApiOperation(value="1-7-1 \u83b7\u53d6\u65b0\u95fb\u5217\u8868", notes="")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"admin:news"})
    public Json<PageWarper<News>> getNews(NewsParam newsParam) {
        return ResultUtil.genSuccessResult((Object)this.adminNewsService.queryNews(newsParam));
    }

    @ApiOperation(value="1-7-2 \u65b0\u95fb\u4e0a\u4e0b\u67b6")
    @PostMapping(value={"/updateNews"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @RequiresPermissions(value={"admin:news"})
    public Json updateNewsStatusById(Long id, Byte status) {
        News news = new News();
        news.setId(id);
        news.setStatus(status);
        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-7-3 \u65b0\u95fb\u6279\u91cf\u4e0a\u4e0b\u67b6")
    @PostMapping(value={"/batchUpdateNews"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @RequiresPermissions(value={"admin:news"})
    public Json updateNewsStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String[] id = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminNewsService.updateNewsStatusByIds(id, status);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
            }
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        return ResultUtil.genFailedResult((String)"\u8bf7\u9009\u62e9\u65b0\u95fb");
    }

    @ApiOperation(value="1-7-4 \u83b7\u53d6\u65b0\u95fb\u8be6\u60c5")
    @GetMapping(value={"/getNewsDetail"})
    @RequiresPermissions(value={"admin:news"})
    public Json<News> getNewsDetail(Long id) {
        News news = this.adminNewsService.selectByPrimaryKey(id);
        return ResultUtil.genSuccessResult((Object)news);
    }

    @ApiOperation(value="1-7-5 \u65b0\u95fb\u7f6e\u9876")
    @PostMapping(value={"/topping"})
    @RequiresPermissions(value={"admin:news"})
    public Json toppingNews(Long id) {
        News news = new News();
        news.setId(id);
        news.setTop(Byte.valueOf((byte)2));
        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-7-5 \u5c06\u65b0\u95fb\u7f6e\u4e3a\u70ed\u95e8")
    @PostMapping(value={"/popularize"})
    @RequiresPermissions(value={"admin:news"})
    public Json popularizeNews(Long id) {
        News news = new News();
        news.setId(id);
        news.setHot(Byte.valueOf((byte)2));
        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }
}

