/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminOpinionInfoDTO;
import com.bxm.localnews.admin.param.AdminOpinionInfoParam;
import com.bxm.localnews.admin.service.AdminOpinionService;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.admin.vo.Feedback;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"1-09 [\u7ba1\u7406]\u7528\u6237\u610f\u89c1\u53cd\u9988"}, description="\u7528\u6237\u53cd\u9988\u7684\u610f\u89c1\u56de\u590d\u4e0e\u67e5\u8be2")
@Controller
@RequestMapping(value={"api/admin/opinion"})
public class AdminOpinionController
extends CommonController {
    private static final Logger logger = LoggerFactory.getLogger(AdminOpinionController.class);
    @Resource
    private AdminOpinionService adminOpinionService;

    @ApiOperation(value="1-9-1 \u610f\u89c1\u53cd\u9988\u5217\u8868", notes="\u83b7\u53d6\u5217\u8868")
    @RequestMapping(value={"queryOpinionList"}, method={RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value={"admin:opinion"})
    public Json<PageWarper<AdminOpinionInfoDTO>> queryOpinionList(AdminOpinionInfoParam param) {
        return ResultUtil.genSuccessResult((Object)this.adminOpinionService.queryOpinions(param));
    }

    @ApiOperation(value="1-9-2 \u66f4\u65b0\u53cd\u9988\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id"), @ApiImplicitParam(name="feedback", value="\u53cd\u9988\u5185\u5bb9")})
    @RequestMapping(value={"updateOpinionInfo"}, method={RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value={"admin:opinion"})
    public Json updateOpinionInfo(@RequestParam(value="id", required=false) String id, @RequestParam(value="feedback", required=false) String feedback) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(id))) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            AdminUser adminUser = this.getLoginUser();
            Feedback opinionInfo = new Feedback();
            opinionInfo.setId(Long.valueOf(Long.parseLong(id)));
            opinionInfo.setReplyContent(feedback);
            opinionInfo.setReplyUserId(adminUser.getId());
            opinionInfo.setStatus(1);
            this.adminOpinionService.updateByPrimaryKeySelective(opinionInfo);
            return ResultUtil.genSuccessMsg((String)"\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("updateOpinionInfoError", (Throwable)e);
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u5904\u7406\u5931\u8d25");
        }
    }
}

