/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-11 [\u7ba1\u7406]\u5b9a\u65f6\u4efb\u52a1"}, description="\u5b9a\u65f6\u4efb\u52a1\u7684\u542f\u52a8\u3001\u6682\u505c\u548c\u6267\u884c\u5468\u671f\u4fee\u6539")
@RestController
@RequestMapping(value={"api/admin/quartz"})
public class AdminQuartzController
extends BaseController {
    private final ScheduleJobService scheduleJobService;

    @Autowired
    public AdminQuartzController(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @ApiOperation(value="1-11-1 \u5206\u9875\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1\u5217\u8868")
    @GetMapping(value={"page"})
    @RequiresPermissions(value={"admin:quartz:list"})
    public Json<PageWarper<ScheduleJobBean>> page(ScheduleJobPageParam param) {
        return Json.build((Object)this.scheduleJobService.queryJobs(param));
    }

    @ApiOperation(value="1-11-2 \u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001,\u542f\u7528\u3001\u7981\u7528\u3001\u6267\u884c\u5468\u671f\u4fee\u6539")
    @RequiresPermissions(value={"admin:quartz:list"})
    @PostMapping(value={"editState"})
    public Json editState(ScheduleJobBean jobBean) {
        if (AppConst.STATE_DISABLE.toString().equals(jobBean.getStatus())) {
            this.scheduleJobService.pause(jobBean.getJobName(), jobBean.getJobGroup());
        } else if (AppConst.STATE_USE.toString().equals(jobBean.getStatus())) {
            this.scheduleJobService.resume(jobBean.getJobName(), jobBean.getJobGroup());
        }
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-11-3 \u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5468\u671f")
    @RequiresPermissions(value={"admin:quartz:list"})
    @PostMapping(value={"edit"})
    public Json edit(ScheduleJobBean jobBean) {
        if (StringUtils.isNotBlank((CharSequence)jobBean.getCronExpression())) {
            this.scheduleJobService.update(jobBean);
        }
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-11-4 \u7acb\u5373\u8fd0\u884c\u5b9a\u65f6\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jobName", value="\u4efb\u52a1\u540d\u79f0"), @ApiImplicitParam(name="jobGroup", value="\u4efb\u52a1\u5206\u7ec4")})
    @PostMapping(value={"run"})
    @RequiresPermissions(value={"admin:quartz:list"})
    public Json run(@RequestParam String jobName, @RequestParam String jobGroup) {
        this.scheduleJobService.run(jobName, jobGroup);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-11-5 \u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1\u8be6\u7ec6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jobName", value="\u4efb\u52a1\u540d\u79f0"), @ApiImplicitParam(name="jobGroup", value="\u4efb\u52a1\u5206\u7ec4")})
    @GetMapping(value={"findById"})
    @RequiresPermissions(value={"admin:quartz:list"})
    public ScheduleJobBean findById(@RequestParam String jobName, @RequestParam String jobGroup) {
        return this.scheduleJobService.getJob(jobName, jobGroup);
    }
}

