/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminRoleDTO;
import com.bxm.localnews.admin.dto.MenuAndPermDTO;
import com.bxm.localnews.admin.dto.MenuDTO;
import com.bxm.localnews.admin.param.RoleParam;
import com.bxm.localnews.admin.service.AdminMenuService;
import com.bxm.localnews.admin.service.AdminRoleMenuService;
import com.bxm.localnews.admin.service.AdminRolePermService;
import com.bxm.localnews.admin.service.AdminRoleService;
import com.bxm.localnews.admin.service.AdminUserRoleService;
import com.bxm.localnews.admin.vo.AdminRole;
import com.bxm.localnews.admin.vo.AdminRoleMenu;
import com.bxm.localnews.admin.vo.AdminRolePerm;
import com.bxm.localnews.admin.vo.AdminUser;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"1-13 [\u7ba1\u7406]\u89d2\u8272\u7ba1\u7406"}, description="\u89d2\u8272\u64cd\u4f5c\u63a5\u53e3")
@Controller
@RequestMapping(value={"api/admin/role"})
public class AdminRoleController
extends CommonController {
    @Resource
    private AdminRoleService adminRoleService;
    @Resource
    private AdminUserRoleService adminUserRoleService;
    @Resource
    private AdminMenuService adminMenuService;
    @Resource
    private AdminRoleMenuService adminRoleMenuService;
    @Resource
    private AdminRolePermService adminRolePermService;

    @ApiOperation(value="1-13-1 \u83b7\u53d6\u5168\u90e8\u89d2\u8272", notes="")
    @GetMapping(value={"list"})
    @ResponseBody
    @RequiresPermissions(value={"admin:role"})
    public Json<PageWarper<AdminRoleDTO>> getAllRoleList(RoleParam param) {
        return ResultUtil.genSuccessResult((Object)this.adminRoleService.selectAll(param));
    }

    @ApiOperation(value="1-13-2 \u4fdd\u5b58\u89d2\u8272\u4fe1\u606f", notes="")
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    @RequiresPermissions(value={"admin:role"})
    public Json saveRole(@RequestBody AdminRole adminRole) {
        String roleCode;
        AdminUser loginUser = this.getLoginUser();
        if (loginUser == null) {
            ResultUtil.genFailedResult((String)"\u8bf7\u5148\u767b\u5f55");
        }
        if (StringUtils.isEmpty((CharSequence)(roleCode = adminRole.getRoleCode()))) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u4e3a\u7a7a");
        }
        AdminRole adminRole1 = this.adminRoleService.selectByRoleCode(roleCode);
        if (adminRole.getId() == null) {
            if (adminRole1 != null) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u91cd\u590d");
            }
            adminRole.setCreateTime(new Date());
            adminRole.setCreateUser(loginUser.getId());
            this.adminRoleService.insertSelective(adminRole);
        }
        if (null != adminRole1 && adminRole.getId() != null && null != adminRole.getRoleCode()) {
            if (adminRole1.getRoleCode().equals(adminRole.getRoleCode()) && !adminRole1.getId().equals(adminRole.getId())) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u552f\u4e00\u6807\u793a\u91cd\u590d");
            }
            adminRole.setUpdateUser(loginUser.getId());
            adminRole.setUpdateTime(new Date());
            this.adminRoleService.updateByPrimaryKeySelective(adminRole);
        }
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-13-3 \u5220\u9664\u89d2\u8272", notes="")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
    @PostMapping(value={"delete"})
    @ResponseBody
    @RequiresPermissions(value={"admin:role"})
    public Json delete(Integer roleId) {
        Integer userNum = this.adminUserRoleService.countByRoleId(roleId);
        if (userNum > 0) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8be5\u89d2\u8272\u5173\u8054\u5176\u4ed6\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.adminRoleService.deleteByPrimaryKey(roleId);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-13-4 \u6839\u636e\u89d2\u8272\u83b7\u53d6\u83dc\u5355\u548c\u6743\u9650\u5217\u8868", notes="")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id")
    @GetMapping(value={"getMenuAndPerm"})
    @ResponseBody
    @RequiresPermissions(value={"admin:role"})
    public Json<List<MenuDTO>> getMenuAndPerm(Integer roleId) {
        List menusAndPermsByRoleId = this.adminMenuService.getMenusAndPermsByRoleId(roleId);
        for (MenuDTO menuDTO : menusAndPermsByRoleId) {
            int i = 0;
            List children = menuDTO.getChildren();
            if (children == null || children.isEmpty()) continue;
            for (MenuDTO child : children) {
                if (child.getChecked() != 1) continue;
                ++i;
            }
            if (children.size() == i) continue;
            menuDTO.setChecked(Integer.valueOf(0));
        }
        return ResultUtil.genSuccessResult((Object)menusAndPermsByRoleId);
    }

    @ApiOperation(value="1-13-5 \u4fdd\u5b58\u89d2\u8272\u62e5\u6709\u83dc\u5355\u548c\u6743\u9650", notes="")
    @RequestMapping(value={"saveMenuAndPerm"}, method={RequestMethod.POST})
    @ResponseBody
    @RequiresPermissions(value={"admin:role"})
    public Json saveMenuAndPerm(@RequestBody MenuAndPermDTO menuAndPermDTO) {
        Integer roleId = menuAndPermDTO.getRoleId();
        if (roleId == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272id\u4e3a\u7a7a");
        }
        AdminRole adminRole = this.adminRoleService.selectByPrimaryKey(roleId);
        if (adminRole != null) {
            this.adminRoleMenuService.deleteByRoleId(roleId);
            for (Integer menuId : menuAndPermDTO.getMenuIds()) {
                AdminRoleMenu adminRoleMenu = new AdminRoleMenu();
                adminRoleMenu.setMenuId(menuId);
                adminRoleMenu.setRoleId(roleId);
                this.adminRoleMenuService.insertSelective(adminRoleMenu);
            }
            this.adminRolePermService.deleteByRoleId(roleId);
            for (Integer permId : menuAndPermDTO.getPermIds()) {
                AdminRolePerm adminRolePerm = new AdminRolePerm();
                adminRolePerm.setPermId(permId);
                adminRolePerm.setRoleId(roleId);
                this.adminRolePermService.insertSelective(adminRolePerm);
            }
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
    }
}

