/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.ToolsParam;
import com.bxm.localnews.admin.service.AdminToolsService;
import com.bxm.localnews.admin.vo.Tools;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-10 [\u7ba1\u7406]\u5de5\u5177\u7ba1\u7406"}, description="\u5de5\u5177\u7ba1\u7406\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/tools"})
public class AdminToolsController {
    private AdminToolsService adminToolsService;

    @Autowired
    public AdminToolsController(AdminToolsService adminToolsService) {
        this.adminToolsService = adminToolsService;
    }

    @ApiOperation(value="1-10-1 \u83b7\u53d6\u5de5\u5177\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u5de5\u5177\u6570\u636e")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"admin:tools"})
    public Json<PageWarper<Tools>> getToolsList(ToolsParam toolsParam) {
        return ResultUtil.genSuccessResult((Object)this.adminToolsService.getToolsList(toolsParam));
    }

    @ApiOperation(value="1-10-2 \u83b7\u53d6\u5de5\u5177\u8be6\u60c5", notes="")
    @GetMapping(value={"/detail"})
    @RequiresPermissions(value={"admin:tools"})
    public Json<Tools> getToolsById(Long id) {
        return ResultUtil.genSuccessResult((Object)this.adminToolsService.getToolsById(id));
    }

    @ApiOperation(value="1-10-3 \u5de5\u5177\u6279\u91cf\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u5b57\u7b26\u4e32\uff0c\u4ee5\u201d,\u201c\u5206\u9694", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"batchUpdateStatus"})
    @RequiresPermissions(value={"admin:tools"})
    public Json updateToolsStatusByIds(String ids, Byte status) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return ResultUtil.genFailedResult((String)"\u5de5\u5177id\u5217\u8868\u4e3a\u7a7a");
        }
        String[] id = ids.split(",");
        if (this.adminToolsService.updateToolsStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-10-4 \u5de5\u5177\u4e0a\u4e0b\u67b6", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"updateStatus"})
    @RequiresPermissions(value={"admin:tools"})
    public Json updateToolsStatusById(Long id, Byte status) {
        if (this.adminToolsService.updateToolsStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-10-5 \u65b0\u589e\u6216\u7f16\u8f91\u5de5\u5177", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCodes", value="\u5730\u533a\u7f16\u7801\u5b57\u7b26\u4e32,\u4ee5\u201c,\u201d\u5206\u9694")})
    @PostMapping(value={"saveOrUpdateTools"})
    @RequiresPermissions(value={"admin:tools"})
    public Json addAdvertDetail(Tools tools, @RequestParam(required=false) String areaCodes) {
        if (this.adminToolsService.addToolsDetail(tools, areaCodes) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @ApiOperation(value="1-10-6 \u5220\u9664\u5de5\u5177", notes="")
    @PostMapping(value={"deleteTools"})
    @RequiresPermissions(value={"admin:tools"})
    public Json deleteTools(Long id) {
        if (this.adminToolsService.deleteTools(id) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u5220\u9664\u5931\u8d25");
    }
}

