/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.AddressBookParam;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.AdminChannelService;
import com.bxm.localnews.admin.service.AdminInviteRelationService;
import com.bxm.localnews.admin.service.AdminUserAddressBookService;
import com.bxm.localnews.admin.service.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.admin.vo.InviteRelation;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserAddressBook;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-17 [\u7ba1\u7406]\u7528\u6237\u7ba1\u7406"}, description="\u7528\u6237\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/user"})
public class AdminUserManageController {
    @Resource
    private AdminChannelService adminChannelService;
    @Resource
    private AdminUserAddressBookService adminUserAddressBookService;
    @Resource
    private AdminInviteRelationService adminInviteRelationService;
    @Resource
    private AdminUserBaseInfoService adminUserBaseInfoService;

    @ApiOperation(value="1-17-1 \u6839\u636e\u6761\u4ef6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"queryUserInfoList"}, method={RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value={"admin:api:user"})
    public Json<PageWarper<UserInfoDTO>> queryUserInfoList(UserInfoParam userInfoParam) {
        if (!StringUtils.isEmpty((CharSequence)userInfoParam.getStartTime())) {
            String startTime = userInfoParam.getStartTime() + " 00:00:00";
            userInfoParam.setStartTime(startTime);
        }
        if (!StringUtils.isEmpty((CharSequence)userInfoParam.getEndTime())) {
            String endTime = userInfoParam.getEndTime() + " 23:59:59";
            userInfoParam.setEndTime(endTime);
        }
        return ResultUtil.genSuccessResult((Object)this.adminUserBaseInfoService.queryUserInfoDTO(userInfoParam));
    }

    @ApiOperation(value="1-17-2 \u67e5\u770b\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @RequestMapping(value={"queryUserBaseInfoByUserId"}, method={RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value={"admin:api:user"})
    public Json<User> queryUserInfoByUserId(@RequestParam(value="userId", required=false) String userId) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        User userBaseInfo = this.adminUserBaseInfoService.selectByUserId(Long.valueOf(Long.parseLong(userId)));
        if (userBaseInfo == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return ResultUtil.genSuccessResult((Object)userBaseInfo);
    }

    @ApiOperation(value="1-17-3 \u8bbe\u7f6e\u548c\u53d6\u6d88\u7528\u6237\u9ed1\u540d\u5355", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="state", value="\u72b6\u6001")})
    @RequestMapping(value={"updateUserBlack"}, method={RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value={"admin:api:user"})
    public Json updateUserBlack(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="state", required=false) String state) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(userId)) || StringUtils.isEmpty((CharSequence)state)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        HashMap map = Maps.newHashMap();
        map.put("userId", userId);
        map.put("state", state);
        boolean flag = this.adminUserBaseInfoService.updateUserBlack((Map)map);
        if (flag) {
            return ResultUtil.genSuccessMsg((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="1-17-4 \u83b7\u53d6\u6e20\u9053\u5217\u8868", notes="")
    @RequestMapping(value={"getChannelList"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<List<Channel>> getChannelList() {
        List channelList = this.adminChannelService.selectRegistChannelList();
        return ResultUtil.genSuccessResult((Object)channelList);
    }

    @ApiOperation(value="1-17-5 \u7528\u6237\u901a\u8baf\u5f55", notes="")
    @GetMapping(value={"addressBook"})
    @RequiresPermissions(value={"admin:api:user"})
    public Json<PageWarper<UserAddressBook>> getUserAddressBook(AddressBookParam addressBookParam) {
        return ResultUtil.genSuccessResult((Object)this.adminUserAddressBookService.queryUserAddressBooks(addressBookParam));
    }

    @ApiOperation(value="1-17-6 \u9080\u8bf7\u8bb0\u5f55", notes="")
    @GetMapping(value={"invitationRecord"})
    @RequiresPermissions(value={"admin:api:user"})
    public Json<PageWarper<InviteRelation>> getInvitationRecord(AddressBookParam addressBookParam) {
        return ResultUtil.genSuccessResult((Object)this.adminInviteRelationService.queryInviteRelations(addressBookParam));
    }
}

