/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.CommodityParam;
import com.bxm.localnews.admin.param.CommodityQueryParam;
import com.bxm.localnews.admin.service.CommodityService;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-20 [\u7ba1\u7406]\u5546\u6237\u5546\u54c1\u7ba1\u7406"}, description="\u5546\u54c1\u4fe1\u606f\u76f8\u5173\u7ba1\u7406\u63a5\u53e3")
@RestController
@RequestMapping(value={"api/admin/commodity"})
public class CommodityController
extends CommonController {
    private CommodityService commodityService;

    @Autowired
    public CommodityController(CommodityService commodityService) {
        this.commodityService = commodityService;
    }

    @ApiOperation(value="1-20-1 \u5206\u9875\u83b7\u53d6\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"commodities"})
    public Json<PageWarper<CommodityBean>> getCommodities(CommodityQueryParam param) {
        return Json.build((Object)this.commodityService.getCommodities(param));
    }

    @ApiOperation(value="1-20-2 \u65b0\u589e\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={"save"})
    public Json save(CommodityParam param) {
        return Json.build((Message)this.commodityService.save(param));
    }

    @ApiOperation(value="1-20-3 \u7f16\u8f91\u5546\u54c1\u4fe1\u606f")
    @PostMapping(value={"modify"})
    public Json modify(CommodityParam param) {
        return Json.build((Message)this.commodityService.modify(param));
    }

    @ApiOperation(value="1-20-4 \u6839\u636e\u5546\u54c1ID\u83b7\u53d6\u5546\u54c1\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u5546\u54c1ID")
    @GetMapping(value={"{id}"})
    public Json<CommodityBean> getDetail(@PathVariable long id) {
        return Json.build((Object)this.commodityService.get(id));
    }

    @ApiOperation(value="1-20-5 \u53d8\u66f4\u5546\u54c1\u4e0a\u4e0b\u67b6\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u54c1ID"), @ApiImplicitParam(name="status", value="\u5546\u54c1\u72b6\u6001,0:\u4e0b\u67b6\uff0c1\uff1a\u4e0a\u67b6")})
    @PostMapping(value={"{id}/{status}"})
    public Json changeStatus(@PathVariable long id, @PathVariable int status) {
        return Json.build((Message)this.commodityService.change(id, status));
    }

    @ApiOperation(value="1-20-6 \u6839\u636e\u5546\u54c1ID\u79fb\u9664\u5546\u54c1\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u5546\u54c1ID")
    @PostMapping(value={"remove/{id}"})
    public Json remove(@PathVariable long id) {
        return Json.build((Message)this.commodityService.remove(id));
    }

    @ApiOperation(value="1-20-7 \u6839\u636e\u5546\u54c1ID\u6216\u5546\u54c1\u540d\u79f0\u83b7\u53d6\u5546\u54c1\u5217\u8868", notes="\u4ec5\u8fd4\u56de\u5339\u914d\u7684\u524d10\u6761\u6570\u636e\uff0c\u8fd4\u56de\u4fe1\u606f\u5305\u542b\u5546\u54c1ID\u3001\u5546\u54c1\u540d\u79f0\u3001\u5546\u54c1\u8be6\u60c5\uff08\u8be6\u60c5\u7528\u4e8e\u6d3b\u52a8\u8be6\u60c5\u8d4b\u503c\uff09")
    @ApiImplicitParam(name="keyword", value="\u5546\u54c1\u540d\u79f0\u6216\u5546\u54c1ID")
    @GetMapping(value={"match/{keyword}"})
    public Json<List<CommodityBean>> getOnlineCommodities(@PathVariable String keyword) {
        return Json.build((Object)this.commodityService.getTopMatchCommodities(keyword));
    }
}

