/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.MerchantParam;
import com.bxm.localnews.admin.param.MerchantQueryParam;
import com.bxm.localnews.admin.service.MerchantService;
import com.bxm.localnews.admin.vo.MerchantBean;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-15 [\u7ba1\u7406]\u5546\u6237\u7ba1\u7406"}, description="\u4f18\u60e0\u6d3b\u52a8\u76f8\u5173\u7684\u5546\u6237\u7ba1\u7406")
@RestController
@RequestMapping(value={"api/admin/merchant"})
public class MerchantController
extends CommonController {
    private MerchantService merchantService;

    @Autowired
    public MerchantController(MerchantService merchantService) {
        this.merchantService = merchantService;
    }

    @ApiOperation(value="1-15-1 \u5206\u9875\u83b7\u53d6\u5546\u6237\u5217\u8868")
    @GetMapping(value={"merchants"})
    public Json<PageWarper<MerchantBean>> getMerchants(MerchantQueryParam param) {
        return Json.build((Object)this.merchantService.getMerchants(param));
    }

    @ApiOperation(value="1-15-2 \u65b0\u589e\u5546\u6237\u4fe1\u606f")
    @PostMapping(value={"save"})
    public Json save(@Valid MerchantParam param) {
        return Json.build((Message)this.merchantService.save(param));
    }

    @ApiOperation(value="1-15-3 \u7f16\u8f91\u5546\u6237\u4fe1\u606f", notes="\u5982\u679c\u7f16\u8f91\u65f6\u5b58\u5728\u76f8\u5e94\u7684\u56fe\u7247\u5219\u8986\u76d6")
    @PostMapping(value={"modify"})
    public Json modify(MerchantParam param) {
        return Json.build((Message)this.merchantService.modify(param));
    }

    @ApiOperation(value="1-15-4 \u6839\u636e\u5546\u6237ID\u83b7\u53d6\u5546\u6237\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u5546\u6237ID", required=true)
    @GetMapping(value={"{id}"})
    public Json<MerchantBean> getDetail(@PathVariable long id) {
        return Json.build((Object)this.merchantService.getMerchant(id));
    }

    @ApiOperation(value="1-15-5 \u53d8\u66f4\u5546\u6237\u72b6\u6001", notes="\u5ba1\u6838\u5546\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5546\u6237ID"), @ApiImplicitParam(name="status", value="\u5ba1\u6838\u72b6\u6001\uff0c0\uff1a\u5f85\u5ba1\u6838\uff0c1\uff1a\u5ba1\u6838\u901a\u8fc7\uff0c2\uff1a\u5ba1\u6838\u9000\u56de"), @ApiImplicitParam(name="rejectReason", value="\u5ba1\u6838\u9000\u56de\u539f\u56e0")})
    @PostMapping(value={"{id}/{status}"})
    public Json changeStatus(@PathVariable long id, @PathVariable int status, String rejectReason) {
        return Json.build((Message)this.merchantService.changeStatus(id, status, rejectReason));
    }

    @ApiOperation(value="1-15-6 \u6839\u636e\u5546\u6237ID\u79fb\u9664\u5546\u6237\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u5546\u6237ID", required=true)
    @PostMapping(value={"remove/{id}"})
    public Json remove(@PathVariable long id) {
        return Json.build((Message)this.merchantService.remove(id));
    }

    @ApiOperation(value="1-15-7 \u6839\u636e\u5546\u6237\u540d\u79f0\u6216\u5546\u6237ID\u68c0\u7d22\u5546\u6237\u4fe1\u606f", notes="\u8fd4\u56de\u524d10\u6761\u7b26\u5408\u6761\u4ef6\u7684\u5546\u6237\u4fe1\u606f\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u4ec5\u5305\u542b\u5546\u6237\u540d\u79f0\u548cID")
    @ApiImplicitParam(name="keyword", value="\u5546\u6237ID\u6216\u5546\u6237\u540d\u79f0")
    @GetMapping(value={"match/{keyword}"})
    public Json<List<MerchantBean>> search(@PathVariable String keyword) {
        return Json.build((Object)this.merchantService.getTopMatch(keyword));
    }
}

