package com.bxm.localnews.admin.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;

import javax.annotation.Resource;

import com.bxm.localnews.admin.param.ActivityParam;
import com.bxm.localnews.admin.service.AdminActivityService;
import com.bxm.localnews.admin.vo.Activity;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-01 [管理]活动管理", description = "活动管理的相关操作")
@RestController
@RequestMapping("api/admin/activity")
public class AdminActivityController {

    @Resource
    private AdminActivityService adminActivityService;

    @ApiOperation(value = "1-1-1 获取活动列表", notes = "根据输入参数获取对应的活动数据")
    @GetMapping("/list")
    public Json<PageWarper<Activity>> getActivityList(ActivityParam activityParam) {
        return ResultUtil.genSuccessResult(this.adminActivityService.queryActivitys(activityParam));
    }

    @ApiOperation(value = "1-1-2 活动批量上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "state", value = "状态", required = true)
    })
    @PostMapping("/batchUpdateActivity")
    public Json updateActivityStatusByIds(String ids, Byte state) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminActivityService.updateActivityStateByIds(id, state);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    @ApiOperation(value = "1-1-3 获取活动详情", notes = "")
    @ApiImplicitParam(name = "id", value = "活动id", required = true)
    @GetMapping("/getActivityDetail")
    public Json<Activity> getActivityDetail(Long id) {
        return ResultUtil.genSuccessResult(this.adminActivityService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-1-4 活动上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "state", value = "状态", required = true)
    })
    @PostMapping("/updateActivity")
    public Json updateActivityStatusById(Long id, Byte state) {
        Activity activity = new Activity();
        activity.setId(id);
        activity.setState(state);
        int flag = this.adminActivityService.updateByPrimaryKeySelective(activity);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-1-5 新增或编辑活动", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "startTime", value = "开始时间"),
            @ApiImplicitParam(name = "endTime", value = "结束时间"),
            @ApiImplicitParam(name = "name", value = "名称"),
            @ApiImplicitParam(name = "activityPic", value = "图片"),
            @ApiImplicitParam(name = "activityUrl", value = "地址"),
            @ApiImplicitParam(name = "id", value = "id"),
            @ApiImplicitParam(name = "state", value = "状态"),
            @ApiImplicitParam(name = "remark", value = "备注")
    })
    @PostMapping("/saveOrUpdateActivity")
    public Json addAdvertDetail(@RequestParam(value = "startTime", required = false) String startTime,
                                @RequestParam(value = "endTime", required = false) String endTime,
                                @RequestParam(value = "name", required = false) String name,
                                @RequestParam(value = "activityPic", required = false) String activityPic,
                                @RequestParam(value = "activityUrl", required = false) String activityUrl,
                                @RequestParam(value = "id", required = false) String id,
                                @RequestParam(value = "state", required = false) String state,
                                @RequestParam(value = "remark", required = false) String remark
    ) throws ParseException {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int flag = 0;
        Activity activity = new Activity(name, activityPic, activityUrl, sdf.parse(startTime), sdf.parse(endTime), Byte.valueOf(state), remark);
        if (StringUtils.isEmpty(id)) {
            flag = this.adminActivityService.insertSelective(activity);
        } else {
            activity.setId(Long.parseLong(id));
            flag = this.adminActivityService.updateByPrimaryKeySelective(activity);
        }
        if (flag <= 0) {
            return ResultUtil.genFailedResult("操作失败");
        }
        return ResultUtil.genSuccessMsg("操作成功");
    }

}
