package com.bxm.localnews.admin.controller;

import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.admin.dto.AdminMenuDTO;
import com.bxm.localnews.admin.service.AdminMenuService;
import com.bxm.localnews.admin.service.AdminRoleMenuService;
import com.bxm.localnews.admin.vo.AdminMenu;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-05 [管理]菜单管理", description = "菜单栏相关操作")
@Controller
@RequestMapping("api/admin/menu")
public class AdminMenuController {

    @Resource
    private AdminMenuService adminMenuService;

    @Resource
    private AdminRoleMenuService adminRoleMenuService;

    @ApiOperation(value = "1-5-1 根据用户角色获取拥有的菜单")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @GetMapping("getRoleMenu")
    @ResponseBody
    public Json<List<AdminMenuDTO>> getRoleMenu(Integer roleId) {
        if (roleId == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数为空");
        }
        return ResultUtil.genSuccessResult(this.adminMenuService.getMenusByRoleId(roleId));
    }

    @ApiOperation(value = "1-5-2 根据角色获取菜单列表")
    @ApiImplicitParam(name = "roleId", value = "角色id")
    @GetMapping("getUserMenu")
    @ResponseBody
    public Json<List<AdminMenuDTO>> getMenuByUserId(Long roleId) {
        List<AdminMenuDTO> allMenus = this.adminMenuService.getMenusByRole(roleId);
        return ResultUtil.genSuccessResult(allMenus);
    }

    /**
     * 获取所有菜单列表
     *
     * @return
     */
    @ApiOperation(value = "1-5-3 获取所有菜单列表")
    @GetMapping("getAllMenu")
    @ResponseBody
    public Json<List<AdminMenuDTO>> getAllMenu() {
        List<AdminMenuDTO> allMenus = this.adminMenuService.getAllMenu();
        return ResultUtil.genSuccessResult(allMenus);
    }

    /**
     * 根据id获取菜单信息
     */
    @ApiOperation(value = "1-5-4 获取菜单详情")
    @ApiImplicitParam(name = "menuId", value = "菜单id")
    @ResponseBody
    @GetMapping("getMenuInfo")
    public Json<AdminMenu> getMenuInfo(@RequestParam(value = "menuId") Integer menuId) {
        AdminMenu menu = this.adminMenuService.selectByPrimaryKey(menuId);
        return ResultUtil.genSuccessResult(menu);
    }

    /**
     * 获取父节点菜单
     *
     * @return
     */
    @ApiOperation(value = "1-5-5 获取父节点菜单")
    @GetMapping("getParentMenuList")
    @ResponseBody
    public Json<List<AdminMenu>> getParentMenuList() {
        return ResultUtil.genSuccessResult(this.adminMenuService.getParentMenus());
    }

    @ApiOperation(value = "1-5-6 保存菜单")
    @RequestMapping(value = "save", method = RequestMethod.POST)
    @ResponseBody
    public Json saveMenu(@RequestBody AdminMenu adminMenu) {
        if (StringUtils.isEmpty(adminMenu.getName())
                || (adminMenu.getLevel() == 1 && StringUtils.isEmpty(adminMenu.getPath()))) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "菜单名称为空或子菜单路径为空");
        }
        int flag = this.adminMenuService.upsert(adminMenu);
        if (flag == 1 || flag > 1) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "数据库异常");
    }

    @ApiOperation(value = "1-5-7 删除菜单")
    @ApiImplicitParam(name = "menuId", value = "菜单id", required = true)
    @PostMapping(value = "delete")
    @ResponseBody
    public Json delete(Integer menuId) {
        Integer userNum = this.adminRoleMenuService.countByMenuId(menuId);
        if (userNum > 0) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "该菜单关联其他角色，不能删除");
        }
        this.adminMenuService.deleteByPrimaryKey(menuId);
        return ResultUtil.genSuccessMsg();
    }

}
