package com.bxm.localnews.admin.controller;

import java.util.Date;

import javax.annotation.Resource;

import com.bxm.localnews.admin.param.MessageParam;
import com.bxm.localnews.admin.service.AdminMessageService;
import com.bxm.localnews.admin.service.PushMsgIntegService;
import com.bxm.localnews.admin.vo.Message;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.mq.common.model.dto.PushAllMessage;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags = "1-06 [管理]系统发送消息管理接口", description = "消息队列中的消息管理")
@Controller
@RequestMapping("api/admin/message")
public class AdminMessageController {

    private final static Logger logger = LoggerFactory.getLogger(AdminMessageController.class);

    @Resource
    private AdminMessageService adminMessageService;

    @Resource
    private PushMsgIntegService pushMsgIntegService;

    @ApiOperation(value = "1-6-1 消息列表", notes = "查询消息列表")
    @RequestMapping(value = "queryMessageList", method = RequestMethod.GET)
    @ResponseBody
    public Json<PageWarper<Message>> queryMessageList(MessageParam messageParam) {

        return ResultUtil.genSuccessResult(this.adminMessageService.queryMessages(messageParam));
    }

    @ApiOperation(value = "1-6-2 保存消息", notes = "保存或者更新消息")
    @RequestMapping(value = "saveOrUpdateMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    public Json addMsgInfo(Message message) {
        try {
            if (message.getId() == null) {
                if (message.getSendType() == 0) {
                    message.setSendState(1);
                    String sendTime = DateUtils.formatDateTime(new Date());// new
                    // Date()为获取当前系统时间
                    message.setSendTime(sendTime);
                    this.adminMessageService.insertSelective(message);
                } else {
                    message.setSendState(0);
                    message.setSendTime(message.getSendTime());
                }
                if (message.getSendType() == 0) {
                    PushAllMessage pushAllMessage = new PushAllMessage();
                    pushAllMessage.setTitle(message.getTitle());
                    pushAllMessage.setContent(message.getContent());
                    this.pushMsgIntegService.pushMsgToAll(pushAllMessage);
                }

                return ResultUtil.genSuccessMsg("新增成功");
            } else {
                if (message.getSendType() == 0) {
                    message.setSendState(1);
                    String sendTime = DateUtils.formatDateTime(new Date());// new
                    // Date()为获取当前系统时间
                    message.setSendTime(sendTime);
                    PushAllMessage pushAllMessage = new PushAllMessage();
                    pushAllMessage.setTitle(message.getTitle());
                    pushAllMessage.setContent(message.getContent());
                    this.pushMsgIntegService.pushMsgToAll(pushAllMessage);
                } else {
                    message.setSendState(0);
                    message.setSendTime(message.getSendTime());
                }
                this.adminMessageService.updateByPrimaryKeySelective(message);
                return ResultUtil.genSuccessMsg("修改成功");
            }
        } catch (Exception e) {
            logger.error("saveOrUpdateMsgInfo", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "1-6-3 删除消息", notes = "")
    @ApiImplicitParam(name = "messageId", value = "消息id")
    @RequestMapping(value = "deleteMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    public Json updateMsgInfo(@RequestParam(value = "messageId", required = false) String messageId) {
        if (StringUtils.isEmpty(messageId)) {
            return ResultUtil.genFailedResult("参数错误");
        }
        try {
            this.adminMessageService.deleteByPrimaryKey(Long.parseLong(messageId));
            return ResultUtil.genSuccessMsg("删除成功");
        } catch (Exception e) {
            logger.error("deleteMsgInfo", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

    @ApiOperation(value = "1-6-4 消息详情", notes = "获取消息详情")
    @ApiImplicitParam(name = "messageId", value = "消息id")
    @RequestMapping(value = "getMsgInfo", method = RequestMethod.GET)
    @ResponseBody
    public Json<Message> getMsgInfo(@RequestParam(value = "messageId", required = true) String messageId) {
        if (StringUtils.isEmpty(messageId)) {
            return ResultUtil.genFailedResult("参数错误");
        }
        try {
            Message messageInfo = this.adminMessageService.selectByPrimaryKey(Long.parseLong(messageId));
            return ResultUtil.genSuccessResult(messageInfo);
        } catch (Exception e) {
            logger.error("getMsgInfoError", e);
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "操作失败");
        }
    }

}
