package com.bxm.localnews.admin.controller;

import javax.annotation.Resource;

import com.bxm.localnews.admin.enums.ShowLevelEnum;
import com.bxm.localnews.admin.param.NewsAddParam;
import com.bxm.localnews.admin.param.NewsParam;
import com.bxm.localnews.admin.param.NewsUpdateParam;
import com.bxm.localnews.admin.service.AdminNewsService;
import com.bxm.localnews.admin.vo.News;
import com.bxm.localnews.admin.vo.NewsKind;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-07 [管理]新闻管理", description = "新闻上线管理，防止受管制的内容出现在线上")
@RestController
@RequestMapping("api/admin/news")
public class AdminNewsController extends BaseController {

    @Resource
    private AdminNewsService adminNewsService;

    @ApiOperation(value = "1-7-1 获取新闻列表", notes = "")
    @PostMapping("/list")
    public Json<PageWarper<News>> getNews(NewsParam newsParam) {

        return ResultUtil.genSuccessResult(this.adminNewsService.queryNews(newsParam));
    }

    @ApiOperation("1-7-2 新闻上下架")
    @PostMapping("/updateNews")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    public Json updateNewsStatusById(Long id, Byte status) {
        News news = new News();
        news.setId(id);
        news.setStatus(status);

        int flag = this.adminNewsService.updateByPrimaryKeySelective(news);

        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation("1-7-3 新闻批量上下架")
    @PostMapping("/batchUpdateNews")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    public Json updateNewsStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.adminNewsService.updateNewsStatusByIds(id, status);

            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    @ApiOperation("1-7-4 获取新闻详情")
    @GetMapping("/getNewsDetail")
    public Json<News> getNewsDetail(Long id) {

        News news = this.adminNewsService.selectByPrimaryKey(id);

        return ResultUtil.genSuccessResult(news);
    }

    @ApiOperation("1-7-5 新闻置顶")
    @PostMapping("/topping")
    public Json toppingNews(Long id) {
      return adminNewsService.settingLevel(ShowLevelEnum.TOP,id);
    }

    @ApiOperation("1-7-5 将新闻置为热门")
    @PostMapping("/popularize")
    public Json popularizeNews(Long id) {
        return adminNewsService.settingLevel(ShowLevelEnum.HOT,id);
    }


    @ApiOperation("1-7-7 新增新闻")
    @PostMapping("/add")
    public Json add(NewsAddParam param){
        return adminNewsService.addNews(param);
    }

    @ApiOperation("1-7-8 修改新闻")
    @PostMapping("/update")
    public Json update(NewsUpdateParam param){
        return adminNewsService.updateNews(param);
    }

    @ApiOperation("1-7-9 获取所有文章分类")
    @GetMapping("/getAllKind")
    public Json<List<NewsKind>> getAllKind(){
        List<NewsKind> list = adminNewsService.getAllKind();
        return ResultUtil.genSuccessResult(list);
    }
}

