package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.PrivilegeService;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

@Api(tags = "1-18 [管理]优惠活动管理", description = "对优惠活动进行相关管理，包括增删查改，状态变更和策略调整")
@RestController
@RequestMapping("/api/admin/privilege")
public class AdminPrivilegeController extends CommonController {

    private PrivilegeService privilegeService;


    @Autowired
    public AdminPrivilegeController(PrivilegeService privilegeService) {
        this.privilegeService = privilegeService;
    }

    @ApiOperation(value = "1-18-1 新增优惠活动信息", notes = "新增活动时ID不需要传递")
    @PostMapping("save")
    public Json save(PrivilegeParam param) {
//        Json checkTimeJson = checkPrivilegeTime(param);
//        if (checkTimeJson != null) {
//            return checkTimeJson;
//        }
        if (param.getGlobalFlag() == 1 && (!StringUtils.isEmpty(param.getAreaCodes()))) {
            return Json.build(RespCode.BAD_REQUEST, "投放区域错误");
        }
        if (param.getGlobalFlag() == 0 && StringUtils.isEmpty(param.getAreaCodes())) {
            return Json.build(RespCode.BAD_REQUEST, "投放区域错误");
        }
        return Json.build(privilegeService.save(param));

    }

    @ApiOperation(value = "1-18-2 编辑优惠活动信息", notes = "编辑活动时ID必须传递")
    @PostMapping("modify")
    public Json modify(PrivilegeParam param) {
        return Json.build(privilegeService.modify(param));
    }

    @ApiOperation(value = "1-18-3 修改活动状态", notes = "设置活动状态为启用或禁用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动ID"),
            @ApiImplicitParam(name = "enable", value = "活动是否可用,0：暂停，1：开启")
    })
    @PostMapping("change/{id}/{enable}")
    public Json change(@PathVariable long id, @PathVariable int enable) {
        return Json.build(privilegeService.changeEnable(id, enable));
    }

    @ApiOperation(value = "1-18-4 分页获取活动列表")
    @GetMapping("privileges")
    public Json<PageWarper<PrivilegeBean>> getPrivileges(PrivilegeQueryParam param) {
        return Json.build(privilegeService.queryByPage(param));
    }

    @ApiOperation(value = "1-18-5 根据活动ID获取活动详情")
    @ApiImplicitParam(name = "id", value = "活动ID", required = true)
    @GetMapping("{id}")
    public Json<PrivilegeBean> getPrivilege(@PathVariable long id) {
        return Json.build(privilegeService.get(id));
    }

    @ApiOperation(value = "1-18-6 移除活动", notes = "只能移除处于禁用状态的活动")
    @ApiImplicitParam(name = "id", value = "活动ID", required = true)
    @PostMapping("remove/{id}")
    public Json remove(@PathVariable long id) {
        return Json.build(privilegeService.remove(id));
    }

    @ApiOperation(value = "1-18-7 权重变更", notes = "变更活动权重，影响排名")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动ID"),
            @ApiImplicitParam(name = "order", value = "活动排序，数值越大，显示越靠前")
    })
    @PostMapping("order/{id}/{order}")
    public Json changeOrder(@PathVariable long id, @PathVariable int order) {
        return Json.build(privilegeService.changeOrder(id, order));
    }

    /**
     * 校验活动开始/结束时间
     *
     * @param param
     * @return
     */
    private Json checkPrivilegeTime(PrivilegeParam param) {
        Date startTime = param.getStartTime();
        Date endTime = param.getEndTime();
        long currentTime = System.currentTimeMillis();

        if ((currentTime + 2 * 60 * 1000L) >= startTime.getTime()) {
            logger.error("活动时间错误:" + startTime.toString() + ":" + endTime.toString());
            return Json.build(RespCode.BAD_REQUEST, "开始时间必须在当前时间2分钟后");
        }
        long proccessingTime = endTime.getTime() - startTime.getTime();
        if (proccessingTime < 10 * 60 * 1000) {
            return Json.build(RespCode.BAD_REQUEST, "结束时间必须在开始时间之后10分钟");
        } else {
            return null;
        }
    }
}