package com.bxm.localnews.admin.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.quartz.service.ScheduleJobService;
import com.bxm.newidea.component.quartz.vo.ScheduleJobBean;
import com.bxm.newidea.component.quartz.vo.ScheduleJobPageParam;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import static com.bxm.localnews.admin.common.AppConst.STATE_DISABLE;
import static com.bxm.localnews.admin.common.AppConst.STATE_USE;


@Api(tags = "1-11 [管理]定时任务", description = "定时任务的启动、暂停和执行周期修改")
@RestController
@RequestMapping("api/admin/quartz")
public class AdminQuartzController extends BaseController {

    private final ScheduleJobService scheduleJobService;

    @Autowired
    public AdminQuartzController(ScheduleJobService scheduleJobService) {
        this.scheduleJobService = scheduleJobService;
    }

    @ApiOperation(value = "1-11-1 分页获取定时任务列表")
    @GetMapping("page")
    public Json<PageWarper<ScheduleJobBean>> page(ScheduleJobPageParam param) {
        return Json.build(scheduleJobService.queryJobs(param));
    }

    @ApiOperation(value = "1-11-2 修改定时任务状态,启用、禁用、执行周期修改")
    @PostMapping("editState")
    public Json editState(ScheduleJobBean jobBean) {
        if (STATE_DISABLE.toString().equals(jobBean.getStatus())) {
            scheduleJobService.pause(jobBean.getJobName(), jobBean.getJobGroup());
        } else if (STATE_USE.toString().equals(jobBean.getStatus())) {
            scheduleJobService.resume(jobBean.getJobName(), jobBean.getJobGroup());
        }

        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation("1-11-3 修改定时任务执行周期")
    @PostMapping("edit")
    public Json edit(ScheduleJobBean jobBean) {
        if (StringUtils.isNotBlank(jobBean.getCronExpression())) {
            scheduleJobService.update(jobBean);
        }

        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "1-11-4 立即运行定时任务")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "jobName", value = "任务名称"),
            @ApiImplicitParam(name = "jobGroup", value = "任务分组")
    })
    @PostMapping("run")
    public Json run(@RequestParam String jobName, @RequestParam String jobGroup) {
        scheduleJobService.run(jobName, jobGroup);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "1-11-5 获取定时任务详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "jobName", value = "任务名称"),
            @ApiImplicitParam(name = "jobGroup", value = "任务分组")
    })
    @GetMapping("findById")
    public ScheduleJobBean findById(@RequestParam String jobName, @RequestParam String jobGroup) {
        return scheduleJobService.getJob(jobName, jobGroup);
    }

}
