package com.bxm.localnews.admin.controller;

import com.bxm.localnews.admin.param.QuartzLogParam;
import com.bxm.localnews.admin.service.QuartzLogService;
import com.bxm.localnews.admin.vo.QuartzLogBean;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-12 [管理]定时任务执行日志", description = "查询定时任务执行结果")
@RestController
@RequestMapping("api/admin/quartz/log")
public class AdminQuartzLogController extends BaseController {

    private final QuartzLogService quartzLogService;

    private Logger logger = LoggerFactory.getLogger(AdminQuartzLogController.class);

    @Autowired
    public AdminQuartzLogController(QuartzLogService quartzLogService) {
        this.quartzLogService = quartzLogService;
    }

    @ApiOperation(value = "1-12-1 获取调度任务列表", notes = "")
    @RequestMapping(value = "page", method = RequestMethod.GET)
    public Json<PageWarper<QuartzLogBean>> page(QuartzLogParam param) {
        PageWarper<QuartzLogBean> result = this.quartzLogService.queryQuartzLogs(param);
        return ResultUtil.genSuccessResult(result);
    }

}
