package com.bxm.localnews.admin.controller;

import java.util.List;

import com.bxm.localnews.admin.param.CommodityParam;
import com.bxm.localnews.admin.param.CommodityQueryParam;
import com.bxm.localnews.admin.service.CommodityService;
import com.bxm.localnews.admin.vo.CommodityBean;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-20 [管理]商户商品管理", description = "商品信息相关管理接口")
@RestController
@RequestMapping("api/admin/commodity")
public class CommodityController extends CommonController {

    private CommodityService commodityService;

    @Autowired
    public CommodityController(CommodityService commodityService) {
        this.commodityService = commodityService;
    }

    @ApiOperation(value = "1-20-1 分页获取商品列表")
    @GetMapping("commodities")
    public Json<PageWarper<CommodityBean>> getCommodities(CommodityQueryParam param) {
        return Json.build(commodityService.getCommodities(param));
    }

    @ApiOperation(value = "1-20-2 新增商品信息")
    @PostMapping("save")
    public Json save(CommodityParam param) {
        return Json.build(commodityService.save(param));
    }

    @ApiOperation(value = "1-20-3 编辑商品信息")
    @PostMapping("modify")
    public Json modify(CommodityParam param) {
        return Json.build(commodityService.modify(param));
    }

    @ApiOperation(value = "1-20-4 根据商品ID获取商品详情")
    @ApiImplicitParam(name = "id", value = "商品ID")
    @GetMapping("{id}")
    public Json<CommodityBean> getDetail(@PathVariable long id) {
        return Json.build(commodityService.get(id));
    }

    @ApiOperation(value = "1-20-5 变更商品上下架状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "商品ID"),
            @ApiImplicitParam(name = "status", value = "商品状态,0:下架，1：上架")
    })
    @PostMapping("{id}/{status}")
    public Json changeStatus(@PathVariable long id, @PathVariable int status) {
        return Json.build(commodityService.change(id, status));
    }

    @ApiOperation(value = "1-20-6 根据商品ID移除商品信息")
    @ApiImplicitParam(name = "id", value = "商品ID")
    @PostMapping("remove/{id}")
    public Json remove(@PathVariable long id) {
        return Json.build(commodityService.remove(id));
    }

    @ApiOperation(value = "1-20-7 根据商品ID或商品名称获取商品列表", notes = "仅返回匹配的前10条数据，返回信息包含商品ID、商品名称、商品详情（详情用于活动详情赋值）")
    @ApiImplicitParam(name = "keyword", value = "商品名称或商品ID")
    @GetMapping("match/{keyword}")
    public Json<List<CommodityBean>> getOnlineCommodities(@PathVariable String keyword) {
        return Json.build(commodityService.getTopMatchCommodities(keyword));
    }

}
