package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdvertDTO;
import com.bxm.localnews.admin.param.AdvertParam;
import com.bxm.localnews.admin.service.activity.AdminAdvertService;
import com.bxm.localnews.admin.vo.Advert;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-02 [管理]广告管理", description = "广告管理的相关操作")
@RestController
@RequestMapping("api/admin/advert")
public class AdminAdvertController extends CommonController {

    private AdminAdvertService adminAdvertService;

    @Autowired
    public AdminAdvertController(AdminAdvertService adminAdvertService) {
        this.adminAdvertService = adminAdvertService;
    }

    @ApiOperation(value = "1-02-1 获取广告列表", notes = "根据输入参数获取对应的广告数据")
    @GetMapping("/list")
    public Json<PageWarper<AdvertDTO>> getAdvertList(AdvertParam advertParam) {
        return ResultUtil.genSuccessResult(this.adminAdvertService.getAdvertList(advertParam));
    }

    @ApiOperation(value = "1-02-2 获取广告详情", notes = "")
    @GetMapping("/detail")
    @ApiImplicitParam(name = "id", value = "id", required = true)
    public Json<AdvertDTO> getAdvertById(Long id) {
        return ResultUtil.genSuccessResult(this.adminAdvertService.getAdvertById(id));
    }

    @ApiOperation(value = "1-02-3 广告批量上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("batchUpdateStatus")
    public Json updateAdvertStatusByIds(String ids, Byte status) {
        if (StringUtils.isBlank(ids)) {
            return ResultUtil.genFailedResult("广告id不存在");
        }
        String[] id = ids.split(",");
        if (this.adminAdvertService.updateAdvertStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-02-4 广告上下架", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("updateStatus")
    public Json updateAdvertStatusById(Long id, Byte status) {
        if (this.adminAdvertService.updateAdvertStatusById(id, status) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-02-5 新增或编辑广告", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCodes", value = "地区编码字符串,以“,”分隔")
    })
    @PostMapping("saveOrUpdateAdvert")
    public Json addAdvertDetail(Advert advert, @RequestParam(required = false) String areaCodes) {
        if (this.adminAdvertService.addAdvertDetail(advert, areaCodes) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-02-6 删除广告", notes = "")
    @PostMapping("deleteAdvert")
    @ApiImplicitParam(name = "id", value = "id", required = true)
    public Json deleteAdvert(Long id) {
        if (this.adminAdvertService.deleteAdvert(id) > 0) {
            return ResultUtil.genSuccessMsg("删除成功");
        }
        return ResultUtil.genFailedResult("删除失败");
    }

    @ApiOperation(value = "1-02-7 获取对应类型广告的最大权重值", notes = "")
    @GetMapping("/maxOrder")
    @ApiImplicitParam(name = "type", value = "type", required = true)
    public Json<Integer> getMaxOrderByType(Byte type) {
        return ResultUtil.genSuccessResult(this.adminAdvertService.getMaxOrderByType(type));
    }
}
