package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.service.forum.ForumPostService;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.ForumPostApproveHistory;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Api(tags = "1-42 [管理]帖子管理", description = "帖子管理")
@RestController
@RequestMapping("api/admin/forumPost")
public class ForumPostController extends CommonController {

    @Resource
    private ForumPostService forumPostService;

    @ApiOperation(value = "1-42-1 获取帖子审核列表")
    @GetMapping("/listApprove")
    public Json<PageWarper<ForumPost>> getApprovePostList(ForumPostParam param) {
        return ResultUtil.genSuccessResult(forumPostService.getApproveList(param));
    }

    @ApiOperation(value = "1-42-2 获取帖子详情")
    @GetMapping("/detail")
    public Json<ForumPost> getForumPostById(Long id) {
        return ResultUtil.genSuccessResult(forumPostService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-42-3 批量帖子审核")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态 " +
                    "1:[审核通过]设置正常显示 " +
                    "3:审核拒绝 " +
                    "4:删除帖子 " +
                    "5:[审核通过]设置仅楼主可见 " +
                    "6:[审核通过]设置本地圈屏蔽", required = true),
            @ApiImplicitParam(name = "comment", value = "审核意见", required = false)
    })
    @PostMapping("approve")
    public Json approve(String ids, Byte status, String comment) {
        AdminUser adminUser = getLoginUser();
        Long userId = null;
        if (null != adminUser) {
            userId = adminUser.getId();
        }
        return ResultUtil.genSuccessResult(forumPostService.approve(ids, status, comment, userId));
    }

    @ApiOperation(value = "1-42-4 新增或编辑帖子")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody ForumPost forumPost) {
        AdminUser adminUser = getLoginUser();
        Long userId = null;
        if (null != adminUser) {
             userId = adminUser.getId();
        }
        Message message = forumPostService.saveOrUpdate(forumPost, userId);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "1-42-5 批量删除或恢复帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "帖子id列表，逗号分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态：1正常 4删除", required = true),
            @ApiImplicitParam(name = "deductGold", value = "是否扣金币：0不扣 1扣", required = false)
    })
    @PostMapping("deleteOrRecover")
    public Json deleteOrRecover(String ids, Byte status, Byte deductGold) {
        return ResultUtil.genSuccessResult(forumPostService.deleteOrRecover(ids, status, deductGold));
    }

    @ApiOperation(value = "1-42-6 获取新增帖子id")
    @GetMapping("/getCreateId")
    public Json<Long> getCreateId() {
        return ResultUtil.genSuccessResult(forumPostService.getCreateId());
    }

    @ApiOperation(value = "1-42-7 获取帖子审核历史列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "action", value = "审批动作：0拒绝，1通过", required = false)
    })
    @GetMapping("/listApproveHistory")
    public Json<List<ForumPostApproveHistory>> getApproveHistoryList(Long id, Integer action) {
        return ResultUtil.genSuccessResult(forumPostService.getApproveHistoryList(id, action));
    }

    @ApiOperation(value = "1-42-8 将帖子内容生成一条待审核状态的本地新闻，插入本地新闻库",notes = "帖子若处于待发布，则新闻也处于待发布")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
    })
    @PostMapping("/transformPost2News")
    public Json transformPost2News(Long id) {
        return forumPostService.transformPost2News(id);
    }


    @ApiOperation(value = "1-42-9 增加帖子马甲号点赞",notes = "帖子马甲号点赞")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子id", required = true),
            @ApiImplicitParam(name = "startTime", value = "开始时间", required = true),
            @ApiImplicitParam(name = "endTime", value = "结束时间", required = true),
            @ApiImplicitParam(name = "num", value = "增加数量", required = true),
    })
    @PostMapping("/addPostLike")
    public Json addPostLike(@RequestParam(value = "postId") Long postId,
                            @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT) Date startTime,
                            @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)  Date endTime,
                            @RequestParam Integer num ) {
        forumPostService.doAddPostLike(postId,startTime,endTime,num);
        return ResultUtil.genSuccessResult();
    }

}

