package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.param.ReplyLibraryCategoryParam;
import com.bxm.localnews.admin.service.forum.ReplyLibraryCategoryService;
import com.bxm.localnews.admin.vo.ReplyLibraryCategory;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "1-47 [管理]评论库类别管理", description = "评论库类别管理")
@RestController
@RequestMapping("api/admin/replyLibraryCategory")
public class ReplyLibraryCategoryController extends BaseController {

    @Resource
    private ReplyLibraryCategoryService replyLibraryCategoryService;

    @ApiOperation(value = "1-47-1 获取评论库类别列表")
    @GetMapping("list")
    public Json<PageWarper<ReplyLibraryCategory>> getList(ReplyLibraryCategoryParam param) {
        return ResultUtil.genSuccessResult(replyLibraryCategoryService.getList(param));
    }

    @ApiOperation(value = "1-47-2 获取评论库类别详情")
    @GetMapping("detail")
    public Json<ReplyLibraryCategory> selectByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(replyLibraryCategoryService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-47-3 新增评论库类别")
    @PostMapping("insert")
    public Json insert(ReplyLibraryCategory replyLibraryCategory) {
        return ResultUtil.genSuccessResult(replyLibraryCategoryService.insert(replyLibraryCategory));
    }

    @ApiOperation(value = "1-47-4 编辑评论库类别")
    @PostMapping("updateByPrimaryKey")
    public Json updateByPrimaryKey(ReplyLibraryCategory replyLibraryCategory) {
        return ResultUtil.genSuccessResult(replyLibraryCategoryService.updateByPrimaryKey(replyLibraryCategory));
    }

    @ApiOperation(value = "1-47-5 删除评论库类别")
    @PostMapping("deleteByPrimaryKey")
    public Json deleteByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(replyLibraryCategoryService.deleteByPrimaryKey(id));
    }

}

