package com.bxm.localnews.admin.controller.forum;

import com.bxm.localnews.admin.param.ReplyCategoryParam;
import com.bxm.localnews.admin.param.ReplyLibraryParam;
import com.bxm.localnews.admin.param.ReplyOriginalParam;
import com.bxm.localnews.admin.service.forum.ReplyLibraryCategoryService;
import com.bxm.localnews.admin.service.forum.ReplyLibraryService;
import com.bxm.localnews.admin.vo.ReplyLibrary;
import com.bxm.localnews.admin.vo.ReplyLibraryCategory;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "1-48 [管理]评论库管理", description = "评论库管理")
@RestController
@RequestMapping("api/admin/replyLibrary")
public class ReplyLibraryController extends BaseController {

    @Resource
    private ReplyLibraryService replyLibraryService;

    @ApiOperation(value = "1-48-1 获取评论列表")
    @GetMapping("list")
    public Json<PageWarper<ReplyLibrary>> getList(ReplyLibraryParam param) {
        return ResultUtil.genSuccessResult(replyLibraryService.getList(param));
    }

    @ApiOperation(value = "1-48-2 获取评论详情")
    @GetMapping("detail")
    public Json<ReplyLibrary> selectByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(replyLibraryService.selectByPrimaryKey(id));
    }

    @ApiOperation(value = "1-48-3 批量新增评论")
    @PostMapping("batchInsert")
    public Json batchInsert(@RequestBody List<ReplyLibrary> replyLibraryList) {
        return ResultUtil.genSuccessResult(replyLibraryService.batchInsert(replyLibraryList));
    }

    @ApiOperation(value = "1-48-4 编辑评论")
    @PostMapping("updateByPrimaryKey")
    public Json updateByPrimaryKey(ReplyLibrary replyLibrary) {
        return ResultUtil.genSuccessResult(replyLibraryService.updateByPrimaryKey(replyLibrary));
    }

    @ApiOperation(value = "1-48-5 删除评论")
    @PostMapping("deleteByPrimaryKey")
    public Json deleteByPrimaryKey(Long id) {
        return ResultUtil.genSuccessResult(replyLibraryService.deleteByPrimaryKey(id));
    }

    @ApiOperation(value = "1-48-6 模拟评论生成")
    @PostMapping("generateVirtualReply")
    public Json generateVirtualReply(@RequestBody ReplyOriginalParam param) {
        replyLibraryService.generateVirtualReply(param);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-48-7 根据评论类型获得获得虚拟评论")
    @PostMapping("getReplyByCategoryId")
    public Json<List<ReplyLibrary>> getReplyByCategoryId(@RequestBody ReplyCategoryParam param) {
        return ResultUtil.genSuccessResult( replyLibraryService.getReplyByCategoryId(param));
    }
}

