package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.param.CommodityQueryParam;
import com.bxm.localnews.admin.vo.CommodityBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface CommodityMapper {

    int deleteByPrimaryKey(Long id);

    int insert(CommodityBean record);

    CommodityBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(CommodityBean record);

    int updateByPrimaryKey(CommodityBean record);

    /**
     * 分页获取商品信息
     * @param param 分页查询参数
     * @return 分页结果
     */
    List<CommodityBean> queryByPageSize(CommodityQueryParam param);

    /**
     * 更新商品状态
     * @param id     商品ID
     * @param status 商品状态
     * @return 影响行数
     */
    int updateStatus(@Param("id") long id, @Param("status") int status);

    /**
     * 检索前10条商品信息，根据商品ID和商品名称进行模糊匹配
     * @param keyword 检索关键字
     * @return 商品结果
     */
    List<CommodityBean> queryTopMatch(String keyword);

    /**
     * 商品的当前库存扣除<code>deduction</code>扣的剩余数量
     * @param id        商品ID
     * @param deduction 扣除数
     * @return 扣除后的剩余数
     */
    int getStoreNum(@Param("id") long id, @Param("deduction") int deduction);

    /**
     * 进行库存扣除
     * @param id       商品ID
     * @param storeNum 扣除数量（支持正负数），正数表示增加、负数表示扣除
     * @return 更新影响行数
     */
    int updateStoreNum(@Param("id") long id, @Param("storeNum") int storeNum);

}