package com.bxm.localnews.news.domain;

import com.bxm.localnews.admin.dto.PostTopicDTO;
import com.bxm.localnews.admin.param.EditorMessageParam;
import com.bxm.localnews.admin.param.ForumPostParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.admin.vo.ForumPostApproveHistory;
import com.bxm.localnews.admin.vo.PostTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ForumPostMapper {

    List<ForumPost> getList(ForumPostParam param);

    ForumPost selectByPrimaryKey(@Param("id") Long id);

    int insertSelective(ForumPost record);

    int updateByIdPartSelective(ForumPost record);

    int updateRecommendById(ForumPost record);

    int addApproveHistory(@Param("id") Long id, @Param("postId") Long postId, @Param("status") Byte status,
                          @Param("comment") String comment, @Param("createTime") Date createTime);

    int batchDeleteTopic(@Param("postId") Long postId);

    int batchInsertTopic(List<PostTopicDTO> list);

    List<ForumPostApproveHistory> getApproveHistoryList(@Param("id") Long id, @Param("action") Integer action);

    int savePostTag(PostTag postTag);

    int deletePostTag(@Param("postId") Long postId);

    int updateComment(@Param("id") Long id,@Param("comments") int comments);

	int updateEditMessageById(EditorMessageParam param);

	int deleteEditMessageById(Long id);
}