package com.bxm.localnews.admin.domain;

import java.util.Date;
import java.util.List;

import com.bxm.localnews.admin.dto.AppVersionDTO;
import com.bxm.localnews.admin.param.AppVersionParam;
import com.bxm.localnews.admin.vo.AppVersion;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/1/10 11:32
 * @desc
 */
@Mapper
public interface AdminAppVersionMapper {

    List<AppVersionDTO> getAppVersionList(AppVersionParam appVersionParam);

    AppVersion selectByPrimaryKey(Long id);

    /**
     * 根据版本信息查询详情
     *
     * @param version
     * @return
     */
    AppVersion getAppVersionByVersion(@Param("channelId") Long channelId, @Param("version") String version);

    int insertSelective(AppVersion appVersion);

    int updateByPrimaryKeySelective(AppVersion appVersion);

    int updateAppVersionStatusById(@Param("ids") String[] ids, @Param("status") Byte status, @Param("force") Byte force);

    int updateForceByVersion(@Param("channelId") Long channelId, @Param("createTime") Date createTime);
}
