package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.vo.security.AdminUser;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface AdminUserMapper {

    int updateByPrimaryKeySelective(AdminUser record);

    AdminUser getByUserName(@Param("username") String username);

    List<AdminUserDTO> queryAdminUser(@Param("user") AdminUserParam user);

    int upsert(@Param("user") AdminUserDTO user);

    AdminUser selectByUsername(@Param("username") String username);

    /**
     * 编辑用户密码
     * @param sysUser 用户实体
     * @return Boolean
     */
    Boolean editUserPassWord(AdminUser sysUser);

    /**
     * 获取用户信息
     * @param id
     * @return
     */
    AdminUser selectById(@Param("id") Long id);
}