package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.vo.AdvertMaterialWithRelation;
import com.bxm.localnews.admin.vo.AdvertPositionRelation;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface AdvertPositionRelationMapper {
    int deleteByPrimaryKey(Long id);

    int insert(AdvertPositionRelation record);

    int insertSelective(AdvertPositionRelation record);

    AdvertPositionRelation selectByPrimaryKey(Long id);


    int updateByPrimaryKeySelective(AdvertPositionRelation record);

    int updateByPrimaryKey(AdvertPositionRelation record);

    /**
     * 根据positionId获取数据
     * @param positionId 投放id
     * @return 查询结果
     */
    List<AdvertMaterialWithRelation> selectByPositionId(@Param(value = "positionId") Long positionId);

    /**
     * 根据positionId删除
     * @param positionId 投放id
     * @return 删除结果
     */
    int deleteByPositionId(@Param(value = "positionId") Long positionId);


    /**
     * 根据materialId获取关联广告投放的id List
     * @param materialId 素材id
     * @return 查询结果
     */
    List<Long> selectByMaterialId(@Param(value = "materialId") Long materialId);
}