package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.vo.PrivilegeAreaBean;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface PrivilegeAreaMapper {

    int deleteByPrimaryKey(Long id);

    int insert(PrivilegeAreaBean record);

    int insertSelective(PrivilegeAreaBean record);

    PrivilegeAreaBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(PrivilegeAreaBean record);

    int updateByPrimaryKey(PrivilegeAreaBean record);

    /**
     * 获取活动的投放区域
     * @param privilegeId 活动ID
     * @return 投放区域列表
     */
    List<PrivilegeAreaBean> getPrivilegeAreas(Long privilegeId);

    /**
     * 根据活动ID移除对应的投放区域信息
     * @param privilegeId 活动ID
     * @return 影响行数
     */
    int deleteByPrivilegeId(Long privilegeId);

}