package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.RedPacketDTO;
import com.bxm.localnews.admin.vo.RedPacket;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface RedPacketMapper {

    int insert(RedPacket redPacket);

    int insertSelective(RedPacket redPacket);

    int updateByPrimaryKeySelective(RedPacket redPacket);

    int updateByPrimaryKey(RedPacket redPacket);

    RedPacket selectByPrimaryKey(Long id);

    /**
     * 获取列表,只获取审核状态大于-1的红包
     * @param redPacket 入参
     * @return 查询结果
     */
    List<RedPacketDTO> queryList(RedPacket redPacket);

    /**
     * 审核红包,更新审核状态、上线状态、审核内容及修改时间,审核拒绝和通过通用一个服务
     * @param redPacket 红包参数
     * @return 更新结果
     */
    int approvalRedPacket(RedPacket redPacket);
}