package com.bxm.localnews.news.domain;

import com.bxm.localnews.admin.param.NewsDetailStatisticsParam;
import com.bxm.localnews.admin.param.NewsSourceStatisticsParam;
import com.bxm.localnews.admin.vo.NewsSourceInfoBean;
import com.bxm.localnews.admin.vo.NewsStatistics;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface NewsStatisticsMapper {
    int save(NewsStatistics newsStatistics);

    int deleteByNewsId(Long newsId);

    /**
     * 根据来源统计新闻信息
     * @param param 统计参数
     * @return 新闻来源统计结果
     */
    List<NewsSourceInfoBean> countWithArea(NewsDetailStatisticsParam param);

    /**
     * 根据新闻来源统计
     * @param param
     * @return
     */
    List<NewsSourceInfoBean> countWithSource(NewsSourceStatisticsParam param);

    int countWithAreaAndTime(@Param("areaCode") String areaCode,
                             @Param("startTime") Date startTime,
                             @Param("endTime") Date endTime,
                             @Param("kindId") Integer kindId);
}
