package com.bxm.localnews.news.domain;

import com.bxm.localnews.admin.dto.PostTopicDTO;
import com.bxm.localnews.admin.param.TopicParam;
import com.bxm.localnews.admin.vo.Topic;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface TopicMapper {

    List<Topic> getList(TopicParam param);

    Topic selectByPrimaryKey(@Param("id") Long id);

    int insert(Topic record);

    int updateByPrimaryKeySelective(Topic record);

    int deletePostsByTopicId(@Param("id") Long id);

    List<Topic> getListByPostId(@Param("postId") Long postId);

    Integer getPostNumByTopicId(@Param("id") Long id);

    List<Long> listPostIdByTopicId(@Param("id") Long id);

    int batchDeleteTopic(@Param("postId") Long postId);

    int batchInsertTopic(List<PostTopicDTO> list);
}