package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.vo.AdvertPosition;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface AdvertPositionMapper {
    int deleteByPrimaryKey(Long id);

    int insert(AdvertPosition record);

    int insertSelective(AdvertPosition record);

    AdvertPosition selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(AdvertPosition record);

    int updateByPrimaryKey(AdvertPosition record);

    List<AdvertPosition> queryAdvertPositionList(AdvertPosition advertPosition);

    /**
     * 查询广告位列表通过上架状态
     * @param enableStatus 上架状态
     * @return 广告位列表
     */
    List<AdvertPosition> queryAdvertPositionListByStatus(@Param("enableStatus") Integer enableStatus);

    /**
     * 更新广告位状态通过广告位id和上架状态
     * @param advertPositionId 广告位id
     * @param enableStatus 上架状态1上架， 0，下架
     * @return 更新记录条数
     */
    int updateAdvertPositionStatus(@Param("advertPositionId") Long advertPositionId, @Param("enableStatus") Integer enableStatus);

}