package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.im.ChatRoomMessageDTO;
import com.bxm.localnews.admin.param.ChatRoomQueryParam;
import com.bxm.localnews.admin.param.ImMessageQueryParam;
import com.bxm.localnews.admin.vo.AllVirtureUserVo;
import com.bxm.localnews.admin.vo.im.HistoryChatBean;
import com.bxm.localnews.admin.vo.im.ImMessageBean;
import com.bxm.localnews.admin.vo.im.UnReplyBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface IMMapper {
    List<ImMessageBean> query(ImMessageQueryParam param);

    String selectContentById(String id);

    List<HistoryChatBean> queryHistory(Long toUserid);

	List<ChatRoomMessageDTO> queryChatRoomRecord(ChatRoomQueryParam param);

    List<Long> selectReplyRecordByVirUserId(Long virtualUserId);

    /**
     * 查询指定用户的最后的私聊时间
     * @param userIds 要查询的用户id
     * @return 私聊时间集合
     */
    List<AllVirtureUserVo> selectLastTimeByUserIds(@Param("userIds") List<Long> userIds);
}
