package com.bxm.localnews.admin.domain;

import java.util.List;

import com.bxm.localnews.admin.dto.PrivilegeListDTO;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.vo.PrivilegeBean;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface PrivilegeMapper {

    int deleteByPrimaryKey(Long id);

    int insert(PrivilegeBean record);

    PrivilegeBean selectByPrimaryKey(Long id);

    int updateByPrimaryKey(PrivilegeBean record);

    /**
     * 分页获取活动信息
     *
     * @param param 分页参数
     * @return 活动信息列表
     */
    List<PrivilegeBean> queryByPageSize(PrivilegeQueryParam param);

    /**
     * 变更活动上下架状态
     *
     * @param id     活动ID
     * @param enable 启用状态
     * @return 影响行数
     */
    int changeEnable(@Param("id") long id, @Param("enable") int enable);

    /**
     * 修改活动状态
     *
     * @param id        活动ID
     * @param status    活动状态
     * @param actualNum 实际中奖人数
     * @return 修改结果
     */
    int changeStatusAndActualNum(@Param("id") long id, @Param("status") int status, @Param("actualNum") int actualNum);

    /**
     * 变更活动排名
     *
     * @param id    活动ID
     * @param order 活动排名
     * @return 影响行数
     */
    int changeOrder(@Param("id") long id, @Param("order") int order);

    /**
     * 获取商品关联的活动的总数（进行中的活动，包括未开始、进行中）
     *
     * @param commodityId 商品ID
     * @return 关联的活动总数
     */
    int getRelationPrivilegeByCommodity(long commodityId);

    List<PrivilegeListDTO> listAllPrivilege(String areaCode);

}