package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.param.TaskParam;
import com.bxm.localnews.admin.vo.TaskBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface TaskMapper {

    /**
     * 分页获取任务列表
     * @param param 查询参数
     * @return 任务列表
     */
    List<TaskBean> getTaskByPageSize(TaskParam param);

    /**
     * 变更任务启用状态
     * @param id
     * @param status
     * @return
     */
    int changeStatus(@Param("id") String id, @Param("status") Byte status);

    /**
     * 根据任务ID获取任务详情
     * @param id 任务ID
     * @return 任务详情
     */
    TaskBean selectByPrimaryKey(Long id);

}

