package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.MerchantUserDTO;
import com.bxm.localnews.admin.dto.security.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.param.security.UserPhoneParam;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface UserMapper {

    List<UserInfoDTO> queryUserByPageSize(UserInfoParam userInfoParam);

    boolean updateUserBlack(Map<String, Object> map);

    User selectByUserId(@Param("userId") long userId);

    UserLoginHistory selectHistoryByUserId(@Param("userId") long userId);

    String selectLocationByUserId(@Param("userId") long userId);

    int countByUserId(@Param("userId") long userId);

//    int addVirtualUser(@Param("nickname") String nickname, @Param("headImg") String headImg);

    int deleteUser(@Param("userId") Long userId);

    int deleteUserEquipment(@Param("equipment") String equipment);

    int updateUser(@Param("userId") Long userId, @Param("weChat") String weChat);

    int updateVipViewRecord(@Param("wechat") String wechat, @Param("newWeChat") String newWeChat);

    int updateVipRecord(@Param("userId") Long userId, @Param("weChat") String weChat);

    List<UserInfoDTO> queryUserInfoList(UserInfoParam userInfoParam);

    /**
     * 3.2.0版本加入
     * 查询已开卡的会员信息,t_user_vip只有部分，所以要单独提供查询
     *
     * @param userInfoParam ： 传参进来
     * @return
     */
    List<UserInfoDTO> queryUserInfoListHasOpenVip(UserInfoParam userInfoParam);

    String getNicknameById(@Param("userId") long userId);

    int minusPostNum(@Param("userId") Long userId);

    /**
     * 扣除用户邀请数量
     * @param userIds : 要扣除的用户id集合
     * @return
     */
    int decrInviteNum(@Param("userIds") List<Long> userIds);

    Integer getStateById(@Param("userId") long userId);

    List<UserInfoDTO> getVirtualUserList();

    int insertSelective(User record);

    int updateByPrimaryKeySelective(User user);

    List<User> getUserByKeyWord(String keyWord);

    /**
     * 查询用户信息
     *
     * @param userId : 用户id
     * @return 用户基本信息列表
     */
    List<MerchantUserDTO> selectUserById(@Param("userId") Long userId);

    /**
     * 昵称模糊查询用户信息
     *
     * @param userName : 用户昵称
     * @return 用户基本信息列表
     */
    List<MerchantUserDTO> selectUserByName(@Param("userName") String userName);

    /**
     * 根据用户id -关联商户id
     *
     * @param userId
     * @param merchantId
     * @return
     */
    int updateUserForMerchantId(@Param("userId") Long userId, @Param("merchantId") Long merchantId);

    /**
     * 根据手机号码查询是否存在用户
     *
     * @param phoneNo 手机号码
     * @return 手机号码对应的用户信息
     */
    UserInfoDTO queryByPhone(@Param("phoneNo") String phoneNo);

    /**
     * 更新手机号码
     *
     * @param param 更新参数
     * @return 影响行数
     */
    int updatePhone(UserPhoneParam param);
}
